/*
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
$(document).ready(function() {

    $(".click-title").mouseenter( function(    e){
        e.preventDefault();
        this.style.cursor="pointer";
    });
    $(".click-title").mousedown( function(event){
        event.preventDefault();
    });

    // Ugly code while this script is shared among several pages
    try{
        refreshHitsPerSecond(true);
    } catch(e){}
    try{
        refreshResponseTimeOverTime(true);
    } catch(e){}
    try{
        refreshResponseTimePercentiles();
    } catch(e){}
});


var responseTimePercentilesInfos = {
        data: {"result": {"minY": 303.0, "minX": 0.0, "maxY": 229345.0, "series": [{"data": [[0.0, 303.0], [0.1, 1974.0], [0.2, 2622.0], [0.3, 2865.0], [0.4, 3472.0], [0.5, 3776.0], [0.6, 4064.0], [0.7, 4375.0], [0.8, 4560.0], [0.9, 4746.0], [1.0, 4887.0], [1.1, 5075.0], [1.2, 5470.0], [1.3, 5654.0], [1.4, 6436.0], [1.5, 6631.0], [1.6, 6945.0], [1.7, 7328.0], [1.8, 7442.0], [1.9, 7799.0], [2.0, 7877.0], [2.1, 8076.0], [2.2, 8173.0], [2.3, 8289.0], [2.4, 8788.0], [2.5, 8834.0], [2.6, 8997.0], [2.7, 9239.0], [2.8, 9480.0], [2.9, 9584.0], [3.0, 9667.0], [3.1, 9920.0], [3.2, 10088.0], [3.3, 10221.0], [3.4, 10506.0], [3.5, 10656.0], [3.6, 10744.0], [3.7, 10928.0], [3.8, 10998.0], [3.9, 11078.0], [4.0, 11156.0], [4.1, 11241.0], [4.2, 11339.0], [4.3, 11387.0], [4.4, 11480.0], [4.5, 11504.0], [4.6, 11734.0], [4.7, 11822.0], [4.8, 11853.0], [4.9, 11926.0], [5.0, 12056.0], [5.1, 12099.0], [5.2, 12183.0], [5.3, 12229.0], [5.4, 12336.0], [5.5, 12451.0], [5.6, 12577.0], [5.7, 12660.0], [5.8, 12771.0], [5.9, 12862.0], [6.0, 12907.0], [6.1, 13025.0], [6.2, 13062.0], [6.3, 13232.0], [6.4, 13327.0], [6.5, 13428.0], [6.6, 13539.0], [6.7, 13599.0], [6.8, 13692.0], [6.9, 13804.0], [7.0, 13856.0], [7.1, 13968.0], [7.2, 14004.0], [7.3, 14067.0], [7.4, 14167.0], [7.5, 14274.0], [7.6, 14361.0], [7.7, 14405.0], [7.8, 14492.0], [7.9, 14575.0], [8.0, 14601.0], [8.1, 14692.0], [8.2, 14772.0], [8.3, 14811.0], [8.4, 14833.0], [8.5, 14968.0], [8.6, 15055.0], [8.7, 15184.0], [8.8, 15203.0], [8.9, 15311.0], [9.0, 15363.0], [9.1, 15421.0], [9.2, 15478.0], [9.3, 15566.0], [9.4, 15611.0], [9.5, 15682.0], [9.6, 15793.0], [9.7, 15837.0], [9.8, 15942.0], [9.9, 16013.0], [10.0, 16091.0], [10.1, 16150.0], [10.2, 16211.0], [10.3, 16261.0], [10.4, 16294.0], [10.5, 16332.0], [10.6, 16431.0], [10.7, 16462.0], [10.8, 16508.0], [10.9, 16581.0], [11.0, 16658.0], [11.1, 16756.0], [11.2, 16811.0], [11.3, 16885.0], [11.4, 16950.0], [11.5, 17011.0], [11.6, 17095.0], [11.7, 17165.0], [11.8, 17227.0], [11.9, 17300.0], [12.0, 17392.0], [12.1, 17445.0], [12.2, 17496.0], [12.3, 17605.0], [12.4, 17714.0], [12.5, 17863.0], [12.6, 17925.0], [12.7, 18017.0], [12.8, 18127.0], [12.9, 18169.0], [13.0, 18280.0], [13.1, 18418.0], [13.2, 18502.0], [13.3, 18626.0], [13.4, 18780.0], [13.5, 18920.0], [13.6, 18997.0], [13.7, 19114.0], [13.8, 19180.0], [13.9, 19236.0], [14.0, 19381.0], [14.1, 19508.0], [14.2, 19652.0], [14.3, 19742.0], [14.4, 19835.0], [14.5, 19984.0], [14.6, 20104.0], [14.7, 20171.0], [14.8, 20302.0], [14.9, 20489.0], [15.0, 20604.0], [15.1, 20755.0], [15.2, 20805.0], [15.3, 20886.0], [15.4, 21061.0], [15.5, 21187.0], [15.6, 21287.0], [15.7, 21473.0], [15.8, 21595.0], [15.9, 21659.0], [16.0, 21747.0], [16.1, 21828.0], [16.2, 22018.0], [16.3, 22104.0], [16.4, 22241.0], [16.5, 22380.0], [16.6, 22543.0], [16.7, 22608.0], [16.8, 22699.0], [16.9, 22820.0], [17.0, 22912.0], [17.1, 22956.0], [17.2, 23091.0], [17.3, 23195.0], [17.4, 23271.0], [17.5, 23404.0], [17.6, 23425.0], [17.7, 23511.0], [17.8, 23567.0], [17.9, 23619.0], [18.0, 23702.0], [18.1, 23827.0], [18.2, 24003.0], [18.3, 24060.0], [18.4, 24120.0], [18.5, 24207.0], [18.6, 24322.0], [18.7, 24493.0], [18.8, 24577.0], [18.9, 24707.0], [19.0, 24768.0], [19.1, 24808.0], [19.2, 24971.0], [19.3, 25062.0], [19.4, 25136.0], [19.5, 25216.0], [19.6, 25297.0], [19.7, 25436.0], [19.8, 25533.0], [19.9, 25636.0], [20.0, 25772.0], [20.1, 25832.0], [20.2, 26036.0], [20.3, 26110.0], [20.4, 26197.0], [20.5, 26261.0], [20.6, 26414.0], [20.7, 26536.0], [20.8, 26603.0], [20.9, 26715.0], [21.0, 26791.0], [21.1, 27023.0], [21.2, 27139.0], [21.3, 27304.0], [21.4, 27592.0], [21.5, 27720.0], [21.6, 27813.0], [21.7, 27975.0], [21.8, 28186.0], [21.9, 28318.0], [22.0, 28480.0], [22.1, 28692.0], [22.2, 28842.0], [22.3, 28911.0], [22.4, 29062.0], [22.5, 29180.0], [22.6, 29362.0], [22.7, 29413.0], [22.8, 29603.0], [22.9, 29702.0], [23.0, 29917.0], [23.1, 30022.0], [23.2, 30286.0], [23.3, 30483.0], [23.4, 30578.0], [23.5, 30710.0], [23.6, 31029.0], [23.7, 31300.0], [23.8, 31427.0], [23.9, 31670.0], [24.0, 31774.0], [24.1, 32059.0], [24.2, 32228.0], [24.3, 32424.0], [24.4, 32617.0], [24.5, 32806.0], [24.6, 32929.0], [24.7, 33266.0], [24.8, 33507.0], [24.9, 33675.0], [25.0, 33827.0], [25.1, 33970.0], [25.2, 34168.0], [25.3, 34346.0], [25.4, 34479.0], [25.5, 34628.0], [25.6, 34896.0], [25.7, 35158.0], [25.8, 35606.0], [25.9, 35821.0], [26.0, 36156.0], [26.1, 36380.0], [26.2, 36814.0], [26.3, 36969.0], [26.4, 37114.0], [26.5, 37285.0], [26.6, 37511.0], [26.7, 37601.0], [26.8, 37854.0], [26.9, 38032.0], [27.0, 38184.0], [27.1, 38343.0], [27.2, 38559.0], [27.3, 38902.0], [27.4, 39376.0], [27.5, 39626.0], [27.6, 39826.0], [27.7, 39928.0], [27.8, 40099.0], [27.9, 40311.0], [28.0, 40590.0], [28.1, 40877.0], [28.2, 41133.0], [28.3, 41321.0], [28.4, 41521.0], [28.5, 41803.0], [28.6, 41993.0], [28.7, 42116.0], [28.8, 42199.0], [28.9, 42372.0], [29.0, 42505.0], [29.1, 42826.0], [29.2, 43006.0], [29.3, 43218.0], [29.4, 43458.0], [29.5, 43606.0], [29.6, 43751.0], [29.7, 44069.0], [29.8, 44323.0], [29.9, 44393.0], [30.0, 44682.0], [30.1, 44906.0], [30.2, 45023.0], [30.3, 45409.0], [30.4, 45586.0], [30.5, 45920.0], [30.6, 46108.0], [30.7, 46361.0], [30.8, 46647.0], [30.9, 46794.0], [31.0, 47009.0], [31.1, 47439.0], [31.2, 47805.0], [31.3, 48020.0], [31.4, 48096.0], [31.5, 48410.0], [31.6, 48656.0], [31.7, 48970.0], [31.8, 49108.0], [31.9, 49634.0], [32.0, 49902.0], [32.1, 50172.0], [32.2, 50442.0], [32.3, 50625.0], [32.4, 50898.0], [32.5, 51030.0], [32.6, 51227.0], [32.7, 51508.0], [32.8, 52028.0], [32.9, 52467.0], [33.0, 53080.0], [33.1, 53313.0], [33.2, 53910.0], [33.3, 54393.0], [33.4, 54689.0], [33.5, 55100.0], [33.6, 55388.0], [33.7, 55624.0], [33.8, 55865.0], [33.9, 56253.0], [34.0, 56437.0], [34.1, 56712.0], [34.2, 56999.0], [34.3, 57526.0], [34.4, 57813.0], [34.5, 58443.0], [34.6, 58532.0], [34.7, 58762.0], [34.8, 59040.0], [34.9, 59379.0], [35.0, 59645.0], [35.1, 59952.0], [35.2, 60070.0], [35.3, 60093.0], [35.4, 60104.0], [35.5, 60123.0], [35.6, 60145.0], [35.7, 60166.0], [35.8, 60211.0], [35.9, 60259.0], [36.0, 60422.0], [36.1, 60513.0], [36.2, 60894.0], [36.3, 61247.0], [36.4, 61615.0], [36.5, 61881.0], [36.6, 62036.0], [36.7, 62269.0], [36.8, 62606.0], [36.9, 62713.0], [37.0, 62883.0], [37.1, 62982.0], [37.2, 63386.0], [37.3, 63443.0], [37.4, 63576.0], [37.5, 63776.0], [37.6, 64106.0], [37.7, 64291.0], [37.8, 64554.0], [37.9, 64824.0], [38.0, 64871.0], [38.1, 64989.0], [38.2, 65303.0], [38.3, 65403.0], [38.4, 65521.0], [38.5, 65714.0], [38.6, 65799.0], [38.7, 66053.0], [38.8, 66223.0], [38.9, 66282.0], [39.0, 66419.0], [39.1, 66636.0], [39.2, 66848.0], [39.3, 66971.0], [39.4, 67123.0], [39.5, 67276.0], [39.6, 67369.0], [39.7, 67456.0], [39.8, 67526.0], [39.9, 67723.0], [40.0, 67773.0], [40.1, 67877.0], [40.2, 68023.0], [40.3, 68040.0], [40.4, 68123.0], [40.5, 68210.0], [40.6, 68271.0], [40.7, 68346.0], [40.8, 68421.0], [40.9, 68558.0], [41.0, 68647.0], [41.1, 68747.0], [41.2, 68974.0], [41.3, 69097.0], [41.4, 69150.0], [41.5, 69293.0], [41.6, 69377.0], [41.7, 69473.0], [41.8, 69553.0], [41.9, 69666.0], [42.0, 69697.0], [42.1, 69797.0], [42.2, 69842.0], [42.3, 69962.0], [42.4, 70142.0], [42.5, 70274.0], [42.6, 70497.0], [42.7, 70625.0], [42.8, 70783.0], [42.9, 71073.0], [43.0, 71201.0], [43.1, 71414.0], [43.2, 71702.0], [43.3, 71885.0], [43.4, 72179.0], [43.5, 72439.0], [43.6, 72824.0], [43.7, 73077.0], [43.8, 73193.0], [43.9, 73394.0], [44.0, 73510.0], [44.1, 73685.0], [44.2, 73814.0], [44.3, 73863.0], [44.4, 73935.0], [44.5, 74029.0], [44.6, 74216.0], [44.7, 74373.0], [44.8, 74487.0], [44.9, 74697.0], [45.0, 74825.0], [45.1, 74931.0], [45.2, 75020.0], [45.3, 75178.0], [45.4, 75272.0], [45.5, 75495.0], [45.6, 75661.0], [45.7, 75793.0], [45.8, 75908.0], [45.9, 76067.0], [46.0, 76162.0], [46.1, 76460.0], [46.2, 76498.0], [46.3, 76593.0], [46.4, 76732.0], [46.5, 76835.0], [46.6, 77030.0], [46.7, 77105.0], [46.8, 77196.0], [46.9, 77344.0], [47.0, 77410.0], [47.1, 77587.0], [47.2, 77722.0], [47.3, 77799.0], [47.4, 77895.0], [47.5, 77980.0], [47.6, 78076.0], [47.7, 78143.0], [47.8, 78305.0], [47.9, 78516.0], [48.0, 78628.0], [48.1, 78872.0], [48.2, 79033.0], [48.3, 79249.0], [48.4, 79301.0], [48.5, 79535.0], [48.6, 79701.0], [48.7, 79824.0], [48.8, 80002.0], [48.9, 80128.0], [49.0, 80310.0], [49.1, 80445.0], [49.2, 80725.0], [49.3, 80834.0], [49.4, 80950.0], [49.5, 81133.0], [49.6, 81222.0], [49.7, 81346.0], [49.8, 81462.0], [49.9, 81638.0], [50.0, 81812.0], [50.1, 81968.0], [50.2, 82162.0], [50.3, 82306.0], [50.4, 82466.0], [50.5, 82779.0], [50.6, 82998.0], [50.7, 83272.0], [50.8, 83750.0], [50.9, 84261.0], [51.0, 84597.0], [51.1, 84987.0], [51.2, 85289.0], [51.3, 85529.0], [51.4, 85809.0], [51.5, 86067.0], [51.6, 86279.0], [51.7, 86413.0], [51.8, 86629.0], [51.9, 86769.0], [52.0, 87026.0], [52.1, 87205.0], [52.2, 87736.0], [52.3, 88115.0], [52.4, 88260.0], [52.5, 88818.0], [52.6, 89101.0], [52.7, 89324.0], [52.8, 89531.0], [52.9, 89660.0], [53.0, 89883.0], [53.1, 90101.0], [53.2, 90321.0], [53.3, 90454.0], [53.4, 90586.0], [53.5, 90752.0], [53.6, 90830.0], [53.7, 90986.0], [53.8, 91139.0], [53.9, 91250.0], [54.0, 91504.0], [54.1, 91725.0], [54.2, 91802.0], [54.3, 91901.0], [54.4, 92107.0], [54.5, 92318.0], [54.6, 92485.0], [54.7, 92665.0], [54.8, 92875.0], [54.9, 92942.0], [55.0, 93165.0], [55.1, 93327.0], [55.2, 93486.0], [55.3, 93889.0], [55.4, 94067.0], [55.5, 94296.0], [55.6, 94477.0], [55.7, 94716.0], [55.8, 94954.0], [55.9, 95035.0], [56.0, 95195.0], [56.1, 95373.0], [56.2, 95503.0], [56.3, 95732.0], [56.4, 95910.0], [56.5, 96083.0], [56.6, 96321.0], [56.7, 96378.0], [56.8, 96495.0], [56.9, 96699.0], [57.0, 97022.0], [57.1, 97252.0], [57.2, 97730.0], [57.3, 98370.0], [57.4, 99188.0], [57.5, 99780.0], [57.6, 100549.0], [57.7, 101017.0], [57.8, 101333.0], [57.9, 102108.0], [58.0, 102700.0], [58.1, 102902.0], [58.2, 103555.0], [58.3, 103852.0], [58.4, 104445.0], [58.5, 105380.0], [58.6, 106069.0], [58.7, 107680.0], [58.8, 109413.0], [58.9, 111832.0], [59.0, 112980.0], [59.1, 114849.0], [59.2, 116900.0], [59.3, 120002.0], [59.4, 120002.0], [59.5, 120002.0], [59.6, 120003.0], [59.7, 120003.0], [59.8, 120003.0], [59.9, 120003.0], [60.0, 120003.0], [60.1, 120003.0], [60.2, 120003.0], [60.3, 120003.0], [60.4, 120003.0], [60.5, 120003.0], [60.6, 120003.0], [60.7, 120004.0], [60.8, 120004.0], [60.9, 120004.0], [61.0, 120004.0], [61.1, 120004.0], [61.2, 120004.0], [61.3, 120004.0], [61.4, 120004.0], [61.5, 120004.0], [61.6, 120005.0], [61.7, 120005.0], [61.8, 120005.0], [61.9, 120005.0], [62.0, 120005.0], [62.1, 120005.0], [62.2, 120005.0], [62.3, 120005.0], [62.4, 120006.0], [62.5, 120006.0], [62.6, 120006.0], [62.7, 120006.0], [62.8, 120006.0], [62.9, 120006.0], [63.0, 120006.0], [63.1, 120007.0], [63.2, 120007.0], [63.3, 120007.0], [63.4, 120007.0], [63.5, 120007.0], [63.6, 120008.0], [63.7, 120008.0], [63.8, 120008.0], [63.9, 120008.0], [64.0, 120008.0], [64.1, 120008.0], [64.2, 120009.0], [64.3, 120009.0], [64.4, 120009.0], [64.5, 120009.0], [64.6, 120009.0], [64.7, 120009.0], [64.8, 120010.0], [64.9, 120010.0], [65.0, 120010.0], [65.1, 120010.0], [65.2, 120010.0], [65.3, 120011.0], [65.4, 120011.0], [65.5, 120011.0], [65.6, 120011.0], [65.7, 120011.0], [65.8, 120012.0], [65.9, 120012.0], [66.0, 120012.0], [66.1, 120012.0], [66.2, 120013.0], [66.3, 120013.0], [66.4, 120013.0], [66.5, 120014.0], [66.6, 120014.0], [66.7, 120014.0], [66.8, 120015.0], [66.9, 120015.0], [67.0, 120016.0], [67.1, 120016.0], [67.2, 120016.0], [67.3, 120017.0], [67.4, 120017.0], [67.5, 120018.0], [67.6, 120019.0], [67.7, 120019.0], [67.8, 120019.0], [67.9, 120020.0], [68.0, 120023.0], [68.1, 120030.0], [68.2, 120078.0], [68.3, 120082.0], [68.4, 120085.0], [68.5, 120088.0], [68.6, 120092.0], [68.7, 120097.0], [68.8, 120099.0], [68.9, 120101.0], [69.0, 120105.0], [69.1, 120108.0], [69.2, 120109.0], [69.3, 120111.0], [69.4, 120113.0], [69.5, 120114.0], [69.6, 120115.0], [69.7, 120116.0], [69.8, 120118.0], [69.9, 120119.0], [70.0, 120120.0], [70.1, 120122.0], [70.2, 120123.0], [70.3, 120129.0], [70.4, 120131.0], [70.5, 120134.0], [70.6, 120140.0], [70.7, 120154.0], [70.8, 120162.0], [70.9, 120173.0], [71.0, 120176.0], [71.1, 120188.0], [71.2, 120194.0], [71.3, 120203.0], [71.4, 120214.0], [71.5, 120229.0], [71.6, 120260.0], [71.7, 120284.0], [71.8, 120367.0], [71.9, 120610.0], [72.0, 120849.0], [72.1, 121088.0], [72.2, 121135.0], [72.3, 121172.0], [72.4, 124509.0], [72.5, 125017.0], [72.6, 125608.0], [72.7, 126288.0], [72.8, 126938.0], [72.9, 127344.0], [73.0, 127810.0], [73.1, 128114.0], [73.2, 128484.0], [73.3, 128952.0], [73.4, 129616.0], [73.5, 130014.0], [73.6, 130380.0], [73.7, 130722.0], [73.8, 131019.0], [73.9, 131176.0], [74.0, 131425.0], [74.1, 131840.0], [74.2, 132226.0], [74.3, 132524.0], [74.4, 132689.0], [74.5, 132814.0], [74.6, 132894.0], [74.7, 133227.0], [74.8, 133500.0], [74.9, 133658.0], [75.0, 133920.0], [75.1, 134135.0], [75.2, 134265.0], [75.3, 134428.0], [75.4, 134693.0], [75.5, 134821.0], [75.6, 135137.0], [75.7, 135493.0], [75.8, 135707.0], [75.9, 135885.0], [76.0, 136130.0], [76.1, 136656.0], [76.2, 137085.0], [76.3, 138111.0], [76.4, 138754.0], [76.5, 139198.0], [76.6, 139638.0], [76.7, 141366.0], [76.8, 142212.0], [76.9, 143603.0], [77.0, 144583.0], [77.1, 146688.0], [77.2, 148725.0], [77.3, 149381.0], [77.4, 150402.0], [77.5, 150760.0], [77.6, 151334.0], [77.7, 152103.0], [77.8, 152749.0], [77.9, 153719.0], [78.0, 154045.0], [78.1, 154529.0], [78.2, 154985.0], [78.3, 155809.0], [78.4, 156580.0], [78.5, 157136.0], [78.6, 157647.0], [78.7, 158310.0], [78.8, 158518.0], [78.9, 158889.0], [79.0, 159389.0], [79.1, 159817.0], [79.2, 160024.0], [79.3, 160530.0], [79.4, 160689.0], [79.5, 161249.0], [79.6, 161739.0], [79.7, 162307.0], [79.8, 162744.0], [79.9, 163454.0], [80.0, 163771.0], [80.1, 164013.0], [80.2, 164248.0], [80.3, 164402.0], [80.4, 164694.0], [80.5, 164921.0], [80.6, 165154.0], [80.7, 165257.0], [80.8, 165535.0], [80.9, 165811.0], [81.0, 166058.0], [81.1, 166257.0], [81.2, 166502.0], [81.3, 166800.0], [81.4, 167068.0], [81.5, 167323.0], [81.6, 167729.0], [81.7, 168064.0], [81.8, 168367.0], [81.9, 168539.0], [82.0, 168854.0], [82.1, 169038.0], [82.2, 169216.0], [82.3, 169801.0], [82.4, 169922.0], [82.5, 170140.0], [82.6, 170375.0], [82.7, 170658.0], [82.8, 170962.0], [82.9, 171376.0], [83.0, 171489.0], [83.1, 171991.0], [83.2, 172846.0], [83.3, 180000.0], [83.4, 180001.0], [83.5, 180001.0], [83.6, 180001.0], [83.7, 180001.0], [83.8, 180001.0], [83.9, 180002.0], [84.0, 180002.0], [84.1, 180002.0], [84.2, 180002.0], [84.3, 180002.0], [84.4, 180002.0], [84.5, 180002.0], [84.6, 180002.0], [84.7, 180002.0], [84.8, 180002.0], [84.9, 180002.0], [85.0, 180002.0], [85.1, 180002.0], [85.2, 180002.0], [85.3, 180002.0], [85.4, 180003.0], [85.5, 180003.0], [85.6, 180003.0], [85.7, 180003.0], [85.8, 180003.0], [85.9, 180003.0], [86.0, 180003.0], [86.1, 180003.0], [86.2, 180003.0], [86.3, 180003.0], [86.4, 180003.0], [86.5, 180003.0], [86.6, 180004.0], [86.7, 180004.0], [86.8, 180004.0], [86.9, 180004.0], [87.0, 180004.0], [87.1, 180004.0], [87.2, 180005.0], [87.3, 180005.0], [87.4, 180005.0], [87.5, 180005.0], [87.6, 180005.0], [87.7, 180005.0], [87.8, 180005.0], [87.9, 180005.0], [88.0, 180006.0], [88.1, 180006.0], [88.2, 180006.0], [88.3, 180006.0], [88.4, 180006.0], [88.5, 180006.0], [88.6, 180006.0], [88.7, 180007.0], [88.8, 180007.0], [88.9, 180007.0], [89.0, 180007.0], [89.1, 180007.0], [89.2, 180008.0], [89.3, 180008.0], [89.4, 180008.0], [89.5, 180008.0], [89.6, 180008.0], [89.7, 180008.0], [89.8, 180008.0], [89.9, 180008.0], [90.0, 180009.0], [90.1, 180009.0], [90.2, 180009.0], [90.3, 180009.0], [90.4, 180009.0], [90.5, 180009.0], [90.6, 180009.0], [90.7, 180010.0], [90.8, 180010.0], [90.9, 180010.0], [91.0, 180010.0], [91.1, 180010.0], [91.2, 180010.0], [91.3, 180010.0], [91.4, 180011.0], [91.5, 180011.0], [91.6, 180011.0], [91.7, 180011.0], [91.8, 180011.0], [91.9, 180011.0], [92.0, 180011.0], [92.1, 180011.0], [92.2, 180011.0], [92.3, 180012.0], [92.4, 180012.0], [92.5, 180012.0], [92.6, 180012.0], [92.7, 180012.0], [92.8, 180012.0], [92.9, 180013.0], [93.0, 180013.0], [93.1, 180013.0], [93.2, 180013.0], [93.3, 180013.0], [93.4, 180013.0], [93.5, 180013.0], [93.6, 180014.0], [93.7, 180014.0], [93.8, 180014.0], [93.9, 180014.0], [94.0, 180014.0], [94.1, 180014.0], [94.2, 180014.0], [94.3, 180015.0], [94.4, 180015.0], [94.5, 180015.0], [94.6, 180015.0], [94.7, 180015.0], [94.8, 180015.0], [94.9, 180015.0], [95.0, 180016.0], [95.1, 180016.0], [95.2, 180016.0], [95.3, 180016.0], [95.4, 180016.0], [95.5, 180017.0], [95.6, 180017.0], [95.7, 180017.0], [95.8, 180017.0], [95.9, 180017.0], [96.0, 180018.0], [96.1, 180018.0], [96.2, 180018.0], [96.3, 180018.0], [96.4, 180018.0], [96.5, 180019.0], [96.6, 180019.0], [96.7, 180019.0], [96.8, 180020.0], [96.9, 180020.0], [97.0, 180020.0], [97.1, 180020.0], [97.2, 180021.0], [97.3, 180021.0], [97.4, 180021.0], [97.5, 180022.0], [97.6, 180022.0], [97.7, 180022.0], [97.8, 180023.0], [97.9, 180024.0], [98.0, 180024.0], [98.1, 180024.0], [98.2, 180025.0], [98.3, 180026.0], [98.4, 180028.0], [98.5, 180030.0], [98.6, 180031.0], [98.7, 180035.0], [98.8, 180042.0], [98.9, 180080.0], [99.0, 181012.0], [99.1, 181015.0], [99.2, 181019.0], [99.3, 181022.0], [99.4, 181027.0], [99.5, 181031.0], [99.6, 181036.0], [99.7, 181041.0], [99.8, 181045.0], [99.9, 182041.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 100.0, "title": "Response Time Percentiles"}},
        getOptions: function() {
            return {
                series: {
                    points: { show: false }
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentiles'
                },
                xaxis: {
                    tickDecimals: 1,
                    axisLabel: "Percentiles",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Percentile value in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : %x.2 percentile was %y ms"
                },
                selection: { mode: "xy" },
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentiles"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesPercentiles"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesPercentiles"), dataset, prepareOverviewOptions(options));
        }
};

/**
 * @param elementId Id of element where we display message
 */
function setEmptyGraph(elementId) {
    $(function() {
        $(elementId).text("No graph series with filter="+seriesFilter);
    });
}

// Response times percentiles
function refreshResponseTimePercentiles() {
    var infos = responseTimePercentilesInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimePercentiles");
        return;
    }
    if (isGraph($("#flotResponseTimesPercentiles"))){
        infos.createGraph();
    } else {
        var choiceContainer = $("#choicesResponseTimePercentiles");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesPercentiles", "#overviewResponseTimesPercentiles");
        $('#bodyResponseTimePercentiles .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 300.0, "maxY": 875.0, "series": [{"data": [[135200.0, 2.0], [180000.0, 875.0], [132900.0, 2.0], [152100.0, 1.0], [158500.0, 1.0], [164900.0, 4.0], [171300.0, 3.0], [66700.0, 2.0], [69900.0, 3.0], [73100.0, 3.0], [76300.0, 3.0], [79500.0, 2.0], [85900.0, 5.0], [82700.0, 3.0], [89100.0, 3.0], [92300.0, 4.0], [95500.0, 1.0], [105100.0, 1.0], [121100.0, 11.0], [130700.0, 3.0], [137000.0, 3.0], [149800.0, 1.0], [169000.0, 5.0], [34500.0, 3.0], [32900.0, 3.0], [134700.0, 3.0], [36100.0, 4.0], [141100.0, 1.0], [37700.0, 3.0], [153900.0, 2.0], [40900.0, 2.0], [39300.0, 3.0], [42500.0, 2.0], [166700.0, 1.0], [44100.0, 2.0], [173100.0, 1.0], [45700.0, 2.0], [48900.0, 2.0], [50500.0, 3.0], [52100.0, 1.0], [55300.0, 1.0], [56900.0, 2.0], [58500.0, 2.0], [60100.0, 24.0], [61700.0, 3.0], [63300.0, 3.0], [64900.0, 5.0], [69000.0, 4.0], [65800.0, 3.0], [72200.0, 3.0], [300.0, 2.0], [75400.0, 3.0], [81800.0, 6.0], [78600.0, 2.0], [85000.0, 2.0], [88200.0, 1.0], [91400.0, 1.0], [94600.0, 4.0], [97800.0, 1.0], [101000.0, 4.0], [104200.0, 1.0], [107400.0, 1.0], [120200.0, 29.0], [126600.0, 1.0], [129800.0, 2.0], [132400.0, 2.0], [138800.0, 1.0], [151600.0, 3.0], [164400.0, 3.0], [170800.0, 1.0], [1000.0, 1.0], [1700.0, 1.0], [1900.0, 3.0], [2000.0, 1.0], [2100.0, 1.0], [2300.0, 1.0], [149300.0, 1.0], [2500.0, 1.0], [162100.0, 2.0], [2600.0, 2.0], [168500.0, 4.0], [2700.0, 2.0], [2800.0, 2.0], [2900.0, 2.0], [3000.0, 1.0], [3300.0, 2.0], [3400.0, 1.0], [3600.0, 2.0], [3700.0, 3.0], [3800.0, 3.0], [3900.0, 1.0], [4000.0, 2.0], [68100.0, 5.0], [4600.0, 1.0], [4800.0, 4.0], [77700.0, 8.0], [74500.0, 2.0], [5000.0, 3.0], [80900.0, 3.0], [5200.0, 2.0], [84100.0, 1.0], [5600.0, 4.0], [5400.0, 2.0], [87300.0, 2.0], [5800.0, 2.0], [90500.0, 5.0], [93700.0, 1.0], [96900.0, 1.0], [6200.0, 1.0], [6400.0, 2.0], [6600.0, 3.0], [103300.0, 1.0], [6800.0, 3.0], [106500.0, 1.0], [112900.0, 1.0], [7200.0, 1.0], [7400.0, 2.0], [7600.0, 3.0], [7800.0, 8.0], [125700.0, 1.0], [8000.0, 5.0], [128900.0, 2.0], [8400.0, 1.0], [134200.0, 6.0], [9200.0, 5.0], [8800.0, 4.0], [9600.0, 6.0], [10000.0, 4.0], [159800.0, 5.0], [10400.0, 3.0], [166200.0, 2.0], [10800.0, 4.0], [11200.0, 7.0], [172600.0, 2.0], [11600.0, 2.0], [12000.0, 10.0], [12400.0, 5.0], [12800.0, 8.0], [13200.0, 4.0], [13600.0, 7.0], [14000.0, 9.0], [14400.0, 10.0], [14800.0, 10.0], [15200.0, 4.0], [15600.0, 8.0], [16000.0, 7.0], [16800.0, 10.0], [17600.0, 4.0], [18400.0, 8.0], [19200.0, 4.0], [20000.0, 3.0], [20800.0, 8.0], [22400.0, 4.0], [21600.0, 8.0], [23200.0, 8.0], [24000.0, 8.0], [24800.0, 6.0], [25600.0, 7.0], [26400.0, 5.0], [27200.0, 4.0], [28000.0, 2.0], [29600.0, 6.0], [28800.0, 6.0], [30400.0, 6.0], [31200.0, 1.0], [32000.0, 6.0], [33600.0, 4.0], [138300.0, 2.0], [131900.0, 2.0], [36800.0, 4.0], [144700.0, 1.0], [38400.0, 2.0], [151100.0, 1.0], [40000.0, 5.0], [41600.0, 4.0], [170300.0, 7.0], [43200.0, 3.0], [44800.0, 2.0], [48000.0, 7.0], [49600.0, 2.0], [51200.0, 3.0], [56000.0, 2.0], [57600.0, 2.0], [59200.0, 2.0], [60800.0, 3.0], [62400.0, 1.0], [64000.0, 2.0], [67200.0, 5.0], [70400.0, 3.0], [73600.0, 3.0], [76800.0, 3.0], [80000.0, 4.0], [83200.0, 3.0], [89600.0, 2.0], [86400.0, 2.0], [92800.0, 6.0], [96000.0, 3.0], [99200.0, 1.0], [105600.0, 1.0], [102400.0, 2.0], [115200.0, 1.0], [124800.0, 1.0], [128000.0, 1.0], [134400.0, 5.0], [153600.0, 2.0], [160000.0, 3.0], [166400.0, 5.0], [172800.0, 1.0], [132100.0, 2.0], [138500.0, 2.0], [151300.0, 2.0], [157700.0, 1.0], [164100.0, 3.0], [170500.0, 1.0], [67100.0, 4.0], [70300.0, 3.0], [73500.0, 6.0], [76700.0, 7.0], [79900.0, 4.0], [86300.0, 4.0], [89500.0, 5.0], [92700.0, 2.0], [95900.0, 4.0], [99100.0, 4.0], [105500.0, 1.0], [115100.0, 1.0], [124700.0, 1.0], [127900.0, 3.0], [136200.0, 1.0], [149000.0, 1.0], [168200.0, 1.0], [181000.0, 54.0], [34700.0, 2.0], [133900.0, 2.0], [33100.0, 3.0], [36300.0, 2.0], [37900.0, 2.0], [39500.0, 2.0], [159500.0, 1.0], [41100.0, 2.0], [42700.0, 2.0], [44300.0, 7.0], [45900.0, 1.0], [47500.0, 1.0], [49100.0, 2.0], [50700.0, 3.0], [53900.0, 3.0], [57100.0, 3.0], [55500.0, 1.0], [58700.0, 5.0], [60300.0, 3.0], [61900.0, 2.0], [65100.0, 1.0], [63500.0, 4.0], [66200.0, 8.0], [69400.0, 7.0], [75800.0, 5.0], [79000.0, 5.0], [85400.0, 2.0], [82200.0, 2.0], [91800.0, 6.0], [95000.0, 5.0], [101400.0, 1.0], [120600.0, 5.0], [127000.0, 1.0], [131600.0, 1.0], [150800.0, 1.0], [157200.0, 2.0], [163600.0, 1.0], [170000.0, 1.0], [135700.0, 4.0], [142100.0, 1.0], [154900.0, 1.0], [167700.0, 2.0], [68500.0, 3.0], [71700.0, 3.0], [74900.0, 5.0], [78100.0, 6.0], [81300.0, 8.0], [84500.0, 2.0], [87700.0, 2.0], [90900.0, 4.0], [94100.0, 3.0], [97300.0, 1.0], [100500.0, 2.0], [103700.0, 1.0], [126100.0, 1.0], [133400.0, 1.0], [152600.0, 1.0], [159000.0, 1.0], [171800.0, 1.0], [165400.0, 1.0], [16900.0, 5.0], [17700.0, 6.0], [19300.0, 5.0], [18500.0, 5.0], [20100.0, 11.0], [20900.0, 2.0], [22500.0, 6.0], [21700.0, 4.0], [23300.0, 3.0], [24100.0, 8.0], [24900.0, 5.0], [26500.0, 5.0], [25700.0, 2.0], [27300.0, 2.0], [28100.0, 2.0], [28900.0, 4.0], [29700.0, 2.0], [30500.0, 5.0], [31300.0, 5.0], [32100.0, 1.0], [33800.0, 3.0], [131100.0, 2.0], [35400.0, 3.0], [143900.0, 1.0], [37000.0, 3.0], [38600.0, 1.0], [40200.0, 4.0], [156700.0, 1.0], [163100.0, 1.0], [41800.0, 5.0], [169500.0, 1.0], [43400.0, 4.0], [45000.0, 1.0], [46600.0, 2.0], [49800.0, 2.0], [51400.0, 1.0], [53000.0, 2.0], [54600.0, 3.0], [56200.0, 3.0], [57800.0, 2.0], [59400.0, 1.0], [61000.0, 1.0], [62600.0, 6.0], [64200.0, 2.0], [67600.0, 3.0], [74000.0, 5.0], [77200.0, 4.0], [80400.0, 5.0], [86800.0, 1.0], [90000.0, 2.0], [93200.0, 3.0], [96400.0, 4.0], [106000.0, 1.0], [102800.0, 2.0], [115600.0, 1.0], [128400.0, 2.0], [136800.0, 1.0], [162400.0, 2.0], [168800.0, 2.0], [134500.0, 1.0], [153700.0, 3.0], [166500.0, 2.0], [67500.0, 5.0], [70700.0, 3.0], [73900.0, 8.0], [77100.0, 8.0], [80300.0, 4.0], [83500.0, 1.0], [86700.0, 2.0], [89900.0, 1.0], [93100.0, 3.0], [96300.0, 8.0], [105900.0, 1.0], [102700.0, 3.0], [109100.0, 1.0], [112300.0, 1.0], [132200.0, 3.0], [138600.0, 1.0], [157800.0, 2.0], [164200.0, 4.0], [170600.0, 3.0], [136300.0, 1.0], [33300.0, 1.0], [34900.0, 2.0], [38100.0, 5.0], [39700.0, 2.0], [161900.0, 2.0], [41300.0, 6.0], [42900.0, 3.0], [168300.0, 1.0], [44500.0, 3.0], [46100.0, 4.0], [47700.0, 2.0], [50900.0, 4.0], [55700.0, 1.0], [58900.0, 1.0], [60500.0, 5.0], [62100.0, 2.0], [65300.0, 5.0], [63700.0, 1.0], [66600.0, 5.0], [69800.0, 9.0], [73000.0, 4.0], [76200.0, 1.0], [79400.0, 2.0], [85800.0, 2.0], [82600.0, 1.0], [89000.0, 1.0], [92200.0, 2.0], [95400.0, 3.0], [101800.0, 1.0], [121000.0, 5.0], [127400.0, 2.0], [130600.0, 1.0], [134000.0, 4.0], [153200.0, 1.0], [159600.0, 1.0], [166000.0, 1.0], [131700.0, 1.0], [138100.0, 1.0], [144500.0, 1.0], [163700.0, 4.0], [170100.0, 1.0], [68900.0, 5.0], [65700.0, 7.0], [72100.0, 3.0], [75300.0, 1.0], [78500.0, 5.0], [81700.0, 5.0], [84900.0, 1.0], [88100.0, 6.0], [91300.0, 4.0], [97700.0, 2.0], [94500.0, 1.0], [100900.0, 1.0], [116900.0, 1.0], [120100.0, 136.0], [8500.0, 1.0], [135800.0, 2.0], [8900.0, 5.0], [142200.0, 1.0], [9700.0, 3.0], [155000.0, 1.0], [10100.0, 3.0], [161400.0, 1.0], [10500.0, 3.0], [167800.0, 1.0], [10900.0, 6.0], [11300.0, 8.0], [11700.0, 5.0], [12100.0, 6.0], [12500.0, 6.0], [12900.0, 5.0], [13300.0, 7.0], [13700.0, 4.0], [14100.0, 5.0], [14500.0, 9.0], [15300.0, 11.0], [14900.0, 6.0], [15700.0, 6.0], [16100.0, 10.0], [17000.0, 10.0], [17800.0, 6.0], [18600.0, 6.0], [19400.0, 4.0], [20200.0, 1.0], [21000.0, 5.0], [21800.0, 7.0], [23400.0, 10.0], [22600.0, 6.0], [24200.0, 5.0], [25000.0, 6.0], [26600.0, 5.0], [25800.0, 6.0], [27400.0, 2.0], [28200.0, 3.0], [29000.0, 6.0], [29800.0, 3.0], [30600.0, 3.0], [31400.0, 4.0], [32200.0, 4.0], [34000.0, 2.0], [133500.0, 3.0], [35600.0, 3.0], [139900.0, 2.0], [146300.0, 1.0], [38800.0, 2.0], [37200.0, 3.0], [152700.0, 2.0], [159100.0, 2.0], [165500.0, 2.0], [171900.0, 3.0], [42000.0, 3.0], [43600.0, 3.0], [46800.0, 3.0], [45200.0, 1.0], [48400.0, 2.0], [50000.0, 3.0], [53200.0, 2.0], [51600.0, 1.0], [54800.0, 2.0], [56400.0, 2.0], [59600.0, 2.0], [61200.0, 3.0], [62800.0, 4.0], [68000.0, 10.0], [71200.0, 5.0], [74400.0, 6.0], [77600.0, 3.0], [80800.0, 3.0], [87200.0, 1.0], [90400.0, 3.0], [93600.0, 1.0], [96800.0, 3.0], [100000.0, 1.0], [103200.0, 1.0], [112800.0, 1.0], [125600.0, 1.0], [128800.0, 1.0], [136000.0, 1.0], [148800.0, 1.0], [168000.0, 2.0], [140100.0, 1.0], [159300.0, 1.0], [165700.0, 1.0], [172100.0, 2.0], [67900.0, 3.0], [71100.0, 4.0], [74300.0, 2.0], [77500.0, 2.0], [80700.0, 6.0], [87100.0, 2.0], [90300.0, 4.0], [93500.0, 1.0], [96700.0, 1.0], [112700.0, 1.0], [125500.0, 2.0], [128700.0, 1.0], [131400.0, 1.0], [144200.0, 2.0], [150600.0, 1.0], [163400.0, 2.0], [169800.0, 6.0], [33500.0, 3.0], [135500.0, 2.0], [35100.0, 1.0], [36700.0, 1.0], [38300.0, 2.0], [148300.0, 1.0], [154700.0, 1.0], [39900.0, 3.0], [161100.0, 2.0], [41500.0, 3.0], [43100.0, 3.0], [44700.0, 2.0], [46300.0, 3.0], [47900.0, 3.0], [51100.0, 2.0], [49500.0, 1.0], [54300.0, 2.0], [57500.0, 2.0], [59100.0, 1.0], [60700.0, 1.0], [65500.0, 4.0], [63900.0, 1.0], [67000.0, 2.0], [70200.0, 5.0], [73400.0, 2.0], [76600.0, 2.0], [79800.0, 4.0], [83000.0, 2.0], [86200.0, 2.0], [89400.0, 3.0], [92600.0, 2.0], [95800.0, 4.0], [102200.0, 1.0], [111800.0, 2.0], [115000.0, 1.0], [124600.0, 2.0], [131000.0, 5.0], [127800.0, 1.0], [133200.0, 4.0], [139600.0, 1.0], [152400.0, 1.0], [158800.0, 1.0], [171600.0, 1.0], [165200.0, 3.0], [137300.0, 1.0], [143700.0, 1.0], [156500.0, 4.0], [69300.0, 7.0], [66100.0, 1.0], [72500.0, 2.0], [75700.0, 2.0], [78900.0, 2.0], [82100.0, 5.0], [85300.0, 2.0], [88500.0, 2.0], [91700.0, 6.0], [94900.0, 4.0], [101300.0, 1.0], [104500.0, 1.0], [110900.0, 2.0], [120500.0, 1.0], [126900.0, 3.0], [130100.0, 2.0], [135000.0, 1.0], [154200.0, 1.0], [160600.0, 4.0], [167000.0, 3.0], [173400.0, 1.0], [17100.0, 8.0], [17900.0, 4.0], [18700.0, 2.0], [20300.0, 3.0], [19500.0, 5.0], [21100.0, 4.0], [21900.0, 1.0], [22700.0, 5.0], [23500.0, 10.0], [24300.0, 2.0], [25100.0, 6.0], [25900.0, 3.0], [26700.0, 8.0], [27500.0, 4.0], [28300.0, 5.0], [29100.0, 4.0], [29900.0, 6.0], [30700.0, 2.0], [31500.0, 1.0], [32300.0, 1.0], [34200.0, 3.0], [132700.0, 4.0], [139100.0, 2.0], [35800.0, 2.0], [37400.0, 2.0], [158300.0, 4.0], [39000.0, 1.0], [40600.0, 3.0], [42200.0, 3.0], [164700.0, 2.0], [171100.0, 2.0], [43800.0, 1.0], [45400.0, 4.0], [47000.0, 2.0], [48600.0, 4.0], [50200.0, 2.0], [51800.0, 1.0], [53400.0, 2.0], [55000.0, 1.0], [56600.0, 2.0], [59800.0, 2.0], [61400.0, 2.0], [64600.0, 1.0], [68400.0, 7.0], [74800.0, 5.0], [78000.0, 7.0], [81200.0, 2.0], [84400.0, 1.0], [94000.0, 3.0], [90800.0, 5.0], [97200.0, 3.0], [100400.0, 2.0], [103600.0, 2.0], [110000.0, 1.0], [113200.0, 1.0], [126000.0, 2.0], [129200.0, 1.0], [144800.0, 1.0], [157600.0, 2.0], [164000.0, 2.0], [170400.0, 1.0], [136100.0, 2.0], [155300.0, 1.0], [161700.0, 1.0], [168100.0, 3.0], [68300.0, 8.0], [71500.0, 4.0], [74700.0, 3.0], [81100.0, 7.0], [77900.0, 6.0], [84300.0, 3.0], [87500.0, 1.0], [90700.0, 6.0], [93900.0, 4.0], [97100.0, 1.0], [103500.0, 1.0], [125900.0, 1.0], [129100.0, 1.0], [133800.0, 4.0], [146600.0, 1.0], [159400.0, 1.0], [165800.0, 6.0], [33700.0, 3.0], [131500.0, 2.0], [137900.0, 2.0], [35300.0, 1.0], [38500.0, 4.0], [36900.0, 4.0], [150700.0, 4.0], [40100.0, 1.0], [157100.0, 1.0], [163500.0, 2.0], [169900.0, 4.0], [44900.0, 5.0], [43300.0, 1.0], [46500.0, 3.0], [48100.0, 1.0], [49700.0, 2.0], [51300.0, 1.0], [52900.0, 2.0], [54500.0, 3.0], [56100.0, 2.0], [59300.0, 2.0], [57700.0, 1.0], [60900.0, 1.0], [62500.0, 3.0], [64100.0, 5.0], [67400.0, 5.0], [70600.0, 4.0], [73800.0, 11.0], [77000.0, 4.0], [80200.0, 5.0], [83400.0, 2.0], [86600.0, 6.0], [89800.0, 4.0], [93000.0, 2.0], [96200.0, 3.0], [99400.0, 3.0], [125000.0, 2.0], [128200.0, 3.0], [135600.0, 2.0], [154800.0, 1.0], [161200.0, 2.0], [167600.0, 1.0], [133300.0, 1.0], [152500.0, 1.0], [158900.0, 1.0], [165300.0, 2.0], [229300.0, 1.0], [4100.0, 4.0], [4300.0, 4.0], [66500.0, 2.0], [4500.0, 5.0], [72900.0, 2.0], [69700.0, 6.0], [4700.0, 4.0], [76100.0, 4.0], [4900.0, 3.0], [5100.0, 2.0], [79300.0, 4.0], [82500.0, 3.0], [85700.0, 1.0], [5500.0, 1.0], [88900.0, 2.0], [5700.0, 1.0], [92100.0, 3.0], [95300.0, 4.0], [6300.0, 1.0], [101700.0, 1.0], [6500.0, 3.0], [104900.0, 1.0], [6900.0, 1.0], [7100.0, 3.0], [7300.0, 5.0], [7500.0, 1.0], [120900.0, 3.0], [7700.0, 2.0], [124100.0, 1.0], [8100.0, 5.0], [127300.0, 2.0], [130500.0, 2.0], [8200.0, 4.0], [8600.0, 1.0], [9000.0, 4.0], [9400.0, 3.0], [150200.0, 2.0], [9800.0, 1.0], [10200.0, 2.0], [156600.0, 1.0], [10600.0, 5.0], [11000.0, 7.0], [11400.0, 9.0], [11800.0, 12.0], [12200.0, 8.0], [12600.0, 7.0], [13000.0, 8.0], [13800.0, 8.0], [13400.0, 4.0], [14200.0, 8.0], [14600.0, 7.0], [15000.0, 6.0], [15800.0, 8.0], [15400.0, 9.0], [16200.0, 12.0], [16400.0, 14.0], [17200.0, 7.0], [18000.0, 8.0], [18800.0, 4.0], [19600.0, 4.0], [20400.0, 3.0], [21200.0, 5.0], [22000.0, 6.0], [22800.0, 6.0], [23600.0, 7.0], [24400.0, 7.0], [25200.0, 8.0], [26000.0, 4.0], [26800.0, 5.0], [27600.0, 3.0], [28400.0, 4.0], [29200.0, 1.0], [30000.0, 3.0], [30800.0, 3.0], [31600.0, 3.0], [32400.0, 3.0], [32800.0, 4.0], [34400.0, 4.0], [135100.0, 2.0], [141500.0, 1.0], [36000.0, 1.0], [37600.0, 3.0], [154300.0, 2.0], [40800.0, 2.0], [160700.0, 1.0], [167100.0, 3.0], [44000.0, 2.0], [45600.0, 2.0], [48800.0, 1.0], [50400.0, 3.0], [52000.0, 2.0], [53600.0, 2.0], [55200.0, 1.0], [56800.0, 3.0], [58400.0, 7.0], [60000.0, 11.0], [61600.0, 1.0], [63200.0, 1.0], [64800.0, 8.0], [68800.0, 2.0], [65600.0, 1.0], [72000.0, 1.0], [75200.0, 4.0], [78400.0, 5.0], [81600.0, 1.0], [84800.0, 3.0], [88000.0, 1.0], [91200.0, 2.0], [94400.0, 2.0], [100800.0, 1.0], [104000.0, 3.0], [110400.0, 1.0], [120000.0, 537.0], [129600.0, 2.0], [131200.0, 3.0], [137600.0, 1.0], [150400.0, 1.0], [156800.0, 1.0], [169600.0, 1.0], [135300.0, 1.0], [154500.0, 4.0], [148100.0, 1.0], [160900.0, 1.0], [167300.0, 2.0], [173700.0, 1.0], [180100.0, 1.0], [68700.0, 3.0], [71900.0, 2.0], [75100.0, 5.0], [81500.0, 3.0], [78300.0, 1.0], [91100.0, 5.0], [94300.0, 3.0], [97500.0, 1.0], [100700.0, 1.0], [107100.0, 1.0], [113500.0, 1.0], [126300.0, 2.0], [133000.0, 1.0], [139400.0, 3.0], [145800.0, 1.0], [158600.0, 3.0], [171400.0, 3.0], [165000.0, 2.0], [33900.0, 6.0], [37100.0, 4.0], [38700.0, 1.0], [162700.0, 1.0], [40300.0, 1.0], [41900.0, 2.0], [169100.0, 3.0], [43500.0, 3.0], [46700.0, 6.0], [45100.0, 2.0], [48300.0, 4.0], [49900.0, 2.0], [53100.0, 2.0], [51500.0, 2.0], [56300.0, 2.0], [57900.0, 1.0], [59500.0, 2.0], [61100.0, 1.0], [62700.0, 4.0], [64300.0, 2.0], [67800.0, 6.0], [71000.0, 3.0], [74200.0, 4.0], [77400.0, 7.0], [83800.0, 2.0], [87000.0, 4.0], [93400.0, 4.0], [90200.0, 4.0], [96600.0, 2.0], [106200.0, 1.0], [103000.0, 1.0], [109400.0, 1.0], [115800.0, 1.0], [125400.0, 1.0], [128600.0, 1.0], [134800.0, 4.0], [154000.0, 2.0], [147600.0, 1.0], [166800.0, 5.0], [132500.0, 4.0], [138900.0, 2.0], [151700.0, 1.0], [164500.0, 1.0], [170900.0, 2.0], [66900.0, 5.0], [70100.0, 4.0], [73300.0, 4.0], [76500.0, 6.0], [79700.0, 3.0], [82900.0, 4.0], [86100.0, 2.0], [89300.0, 2.0], [92500.0, 4.0], [95700.0, 2.0], [102100.0, 2.0], [98900.0, 1.0], [105300.0, 1.0], [124500.0, 1.0], [127700.0, 1.0], [130900.0, 1.0], [136600.0, 2.0], [155800.0, 1.0], [168600.0, 1.0], [16500.0, 9.0], [17300.0, 7.0], [18100.0, 8.0], [18900.0, 6.0], [19700.0, 6.0], [21300.0, 5.0], [20500.0, 5.0], [22100.0, 5.0], [22900.0, 8.0], [23700.0, 6.0], [24500.0, 6.0], [25300.0, 3.0], [26100.0, 9.0], [27700.0, 5.0], [28500.0, 2.0], [29300.0, 8.0], [30100.0, 1.0], [31700.0, 5.0], [30900.0, 1.0], [32500.0, 4.0], [34600.0, 3.0], [134300.0, 1.0], [36200.0, 2.0], [147100.0, 1.0], [37800.0, 3.0], [159900.0, 1.0], [42600.0, 1.0], [41000.0, 1.0], [44200.0, 2.0], [172700.0, 1.0], [45800.0, 1.0], [49000.0, 4.0], [47400.0, 3.0], [50600.0, 2.0], [52200.0, 2.0], [55400.0, 3.0], [57000.0, 1.0], [60200.0, 10.0], [61800.0, 4.0], [63400.0, 8.0], [65000.0, 1.0], [66000.0, 5.0], [69200.0, 4.0], [72400.0, 1.0], [75600.0, 6.0], [78800.0, 5.0], [85200.0, 3.0], [82000.0, 2.0], [88400.0, 1.0], [91600.0, 3.0], [94800.0, 4.0], [98000.0, 2.0], [104400.0, 1.0], [107600.0, 1.0], [120400.0, 2.0], [126800.0, 2.0], [130000.0, 1.0], [133600.0, 3.0], [140000.0, 1.0], [152800.0, 1.0], [159200.0, 1.0], [165600.0, 3.0], [131300.0, 2.0], [150500.0, 2.0], [156900.0, 1.0], [163300.0, 2.0], [169700.0, 1.0], [69100.0, 7.0], [65900.0, 1.0], [72300.0, 1.0], [75500.0, 3.0], [81900.0, 2.0], [88300.0, 1.0], [91500.0, 2.0], [94700.0, 2.0], [97900.0, 1.0], [101100.0, 2.0], [104300.0, 1.0], [107500.0, 1.0], [120300.0, 3.0], [129900.0, 2.0], [135400.0, 4.0], [141800.0, 2.0], [154600.0, 1.0], [167400.0, 3.0], [34100.0, 2.0], [133100.0, 2.0], [35700.0, 4.0], [37300.0, 2.0], [38900.0, 3.0], [40500.0, 5.0], [158700.0, 2.0], [42100.0, 8.0], [165100.0, 5.0], [171500.0, 1.0], [43700.0, 4.0], [46900.0, 1.0], [45300.0, 1.0], [48500.0, 2.0], [50100.0, 2.0], [51700.0, 1.0], [53300.0, 2.0], [54900.0, 1.0], [56500.0, 1.0], [58100.0, 1.0], [59700.0, 1.0], [62900.0, 4.0], [64500.0, 4.0], [68200.0, 8.0], [71400.0, 3.0], [74600.0, 5.0], [77800.0, 6.0], [81000.0, 4.0], [84200.0, 1.0], [87400.0, 2.0], [93800.0, 3.0], [90600.0, 3.0], [97000.0, 3.0], [100200.0, 1.0], [113000.0, 1.0], [129000.0, 1.0], [143600.0, 2.0], [162800.0, 2.0], [156400.0, 1.0], [169200.0, 2.0], [182000.0, 5.0], [134900.0, 1.0], [141300.0, 1.0], [160500.0, 5.0], [67300.0, 5.0], [70500.0, 3.0], [73700.0, 1.0], [76900.0, 4.0], [80100.0, 2.0], [83300.0, 2.0], [86500.0, 2.0], [89700.0, 3.0], [92900.0, 4.0], [96100.0, 1.0], [99300.0, 1.0], [105700.0, 1.0], [102500.0, 1.0], [108900.0, 1.0], [124900.0, 1.0], [128100.0, 2.0], [8300.0, 1.0], [8700.0, 4.0], [132600.0, 2.0], [9500.0, 5.0], [9900.0, 3.0], [158200.0, 1.0], [10700.0, 5.0], [10300.0, 2.0], [164600.0, 3.0], [171000.0, 1.0], [11100.0, 6.0], [11500.0, 4.0], [11900.0, 3.0], [12700.0, 5.0], [12300.0, 4.0], [13100.0, 3.0], [13500.0, 9.0], [14300.0, 4.0], [13900.0, 8.0], [14700.0, 7.0], [15100.0, 9.0], [15500.0, 8.0], [16300.0, 8.0], [15900.0, 7.0], [17400.0, 11.0], [16600.0, 5.0], [18200.0, 4.0], [19000.0, 5.0], [19800.0, 8.0], [20600.0, 3.0], [21400.0, 3.0], [22200.0, 4.0], [23000.0, 4.0], [23800.0, 5.0], [25400.0, 5.0], [24600.0, 3.0], [26200.0, 6.0], [27000.0, 3.0], [27800.0, 4.0], [28600.0, 5.0], [29400.0, 3.0], [30200.0, 3.0], [31000.0, 3.0], [32600.0, 3.0], [31800.0, 1.0], [34800.0, 3.0], [33200.0, 3.0], [136700.0, 1.0], [143100.0, 2.0], [36400.0, 1.0], [38000.0, 2.0], [39600.0, 3.0], [155900.0, 2.0], [162300.0, 1.0], [41200.0, 3.0], [42800.0, 3.0], [44400.0, 1.0], [46000.0, 4.0], [47600.0, 1.0], [50800.0, 2.0], [49200.0, 1.0], [52400.0, 1.0], [55600.0, 4.0], [57200.0, 1.0], [58800.0, 3.0], [60400.0, 4.0], [62000.0, 3.0], [63600.0, 4.0], [65200.0, 3.0], [66400.0, 2.0], [69600.0, 11.0], [72800.0, 4.0], [76000.0, 4.0], [79200.0, 7.0], [82400.0, 3.0], [88800.0, 3.0], [92000.0, 1.0], [95200.0, 3.0], [108000.0, 2.0], [114400.0, 1.0], [111200.0, 1.0], [120800.0, 2.0], [124000.0, 1.0], [127200.0, 1.0], [130400.0, 2.0], [132800.0, 7.0], [139200.0, 1.0], [152000.0, 1.0], [158400.0, 1.0], [164800.0, 1.0], [171200.0, 2.0], [136900.0, 1.0], [149700.0, 2.0], [162500.0, 2.0], [168900.0, 3.0], [66300.0, 4.0], [69500.0, 3.0], [72700.0, 2.0], [75900.0, 4.0], [79100.0, 1.0], [85500.0, 4.0], [82300.0, 3.0], [91900.0, 4.0], [95100.0, 3.0], [98300.0, 1.0], [104700.0, 2.0], [120700.0, 1.0], [130300.0, 3.0], [134600.0, 2.0], [153800.0, 1.0], [160200.0, 1.0], [166600.0, 2.0], [138700.0, 2.0], [132300.0, 2.0], [34300.0, 5.0], [35900.0, 1.0], [37500.0, 6.0], [39100.0, 2.0], [157900.0, 1.0], [40700.0, 1.0], [42300.0, 7.0], [164300.0, 2.0], [170700.0, 1.0], [43900.0, 2.0], [45500.0, 3.0], [47100.0, 2.0], [48700.0, 2.0], [50300.0, 1.0], [51900.0, 2.0], [55100.0, 4.0], [56700.0, 3.0], [59900.0, 4.0], [61500.0, 1.0], [63100.0, 2.0], [64700.0, 2.0], [68600.0, 7.0], [71800.0, 3.0], [75000.0, 6.0], [78200.0, 2.0], [81400.0, 3.0], [84600.0, 2.0], [87800.0, 2.0], [94200.0, 1.0], [91000.0, 3.0], [97400.0, 1.0], [103800.0, 2.0], [126200.0, 1.0], [129400.0, 1.0], [136400.0, 1.0], [149200.0, 1.0], [162000.0, 1.0], [168400.0, 4.0], [134100.0, 3.0], [146900.0, 1.0], [166100.0, 4.0], [67700.0, 9.0], [70900.0, 3.0], [77300.0, 4.0], [74100.0, 1.0], [80500.0, 2.0], [83700.0, 2.0], [86900.0, 3.0], [90100.0, 2.0], [93300.0, 3.0], [96500.0, 4.0], [99700.0, 1.0], [102900.0, 3.0], [112500.0, 1.0], [128500.0, 1.0], [131800.0, 1.0], [157400.0, 1.0], [163800.0, 2.0], [170200.0, 1.0], [16700.0, 7.0], [18300.0, 2.0], [17500.0, 5.0], [19100.0, 9.0], [19900.0, 2.0], [20700.0, 7.0], [21500.0, 4.0], [22300.0, 4.0], [23100.0, 5.0], [23900.0, 1.0], [24700.0, 9.0], [25500.0, 6.0], [26300.0, 4.0], [27100.0, 4.0], [27900.0, 5.0], [28700.0, 2.0], [29500.0, 2.0], [30300.0, 1.0], [31100.0, 2.0], [32700.0, 2.0], [31900.0, 1.0], [135900.0, 3.0], [33400.0, 3.0], [36600.0, 2.0], [142300.0, 3.0], [35000.0, 2.0], [38200.0, 4.0], [155100.0, 2.0], [148700.0, 2.0], [39800.0, 5.0], [161500.0, 3.0], [43000.0, 3.0], [167900.0, 2.0], [44600.0, 3.0], [46200.0, 1.0], [47800.0, 2.0], [51000.0, 4.0], [49400.0, 1.0], [52600.0, 2.0], [54200.0, 2.0], [55800.0, 3.0], [59000.0, 3.0], [62200.0, 3.0], [65400.0, 6.0], [63800.0, 1.0], [66800.0, 4.0], [73200.0, 3.0], [70000.0, 2.0], [76400.0, 7.0], [79600.0, 4.0], [82800.0, 1.0], [86000.0, 3.0], [89200.0, 3.0], [92400.0, 4.0], [95600.0, 4.0], [102000.0, 2.0], [98800.0, 1.0], [114800.0, 1.0], [130800.0, 1.0], [127600.0, 1.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 100, "maxX": 229300.0, "title": "Response Time Distribution"}},
        getOptions: function() {
            var granularity = this.data.result.granularity;
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    barWidth: this.data.result.granularity
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " responses for " + label + " were between " + xval + " and " + (xval + granularity) + " ms";
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimeDistribution"), prepareData(data.result.series, $("#choicesResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshResponseTimeDistribution() {
    var infos = responseTimeDistributionInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeDistribution");
        return;
    }
    if (isGraph($("#flotResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var syntheticResponseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 0.0, "ticks": [[0, "Requests having \nresponse time <= 500ms"], [1, "Requests having \nresponse time > 500ms and <= 1,500ms"], [2, "Requests having \nresponse time > 1,500ms"], [3, "Requests in error"]], "maxY": 3692.0, "series": [{"data": [[0.0, 2.0]], "color": "#9ACD32", "isOverall": false, "label": "Requests having \nresponse time <= 500ms", "isController": false}, {"data": [[1.0, 1.0]], "color": "yellow", "isOverall": false, "label": "Requests having \nresponse time > 500ms and <= 1,500ms", "isController": false}, {"data": [[2.0, 3692.0]], "color": "orange", "isOverall": false, "label": "Requests having \nresponse time > 1,500ms", "isController": false}, {"data": [[3.0, 1900.0]], "color": "#FF6347", "isOverall": false, "label": "Requests in error", "isController": false}], "supportsControllersDiscrimination": false, "maxX": 3.0, "title": "Synthetic Response Times Distribution"}},
        getOptions: function() {
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendSyntheticResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times ranges",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                    tickLength:0,
                    min:-0.5,
                    max:3.5
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    align: "center",
                    barWidth: 0.25,
                    fill:.75
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " " + label;
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            options.xaxis.ticks = data.result.ticks;
            $.plot($("#flotSyntheticResponseTimeDistribution"), prepareData(data.result.series, $("#choicesSyntheticResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshSyntheticResponseTimeDistribution() {
    var infos = syntheticResponseTimeDistributionInfos;
    prepareSeries(infos.data, true);
    if (isGraph($("#flotSyntheticResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerSyntheticResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var activeThreadsOverTimeInfos = {
        data: {"result": {"minY": 44.5, "minX": 1.69659612E12, "maxY": 1571.0221354166667, "series": [{"data": [[1.69659624E12, 1249.9706275033386], [1.69659642E12, 1022.2880698351108], [1.69659612E12, 437.01047120418826], [1.6965966E12, 188.0], [1.6965963E12, 1312.046762589928], [1.69659648E12, 1401.5981554677203], [1.69659618E12, 969.2678288431065], [1.69659666E12, 44.5], [1.69659636E12, 1571.0221354166667], [1.69659654E12, 738.0621531631509]], "isOverall": false, "label": "jp@gc - Ultimate Thread Group", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69659666E12, "title": "Active Threads Over Time"}},
        getOptions: function() {
            return {
                series: {
                    stack: true,
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 6,
                    show: true,
                    container: '#legendActiveThreadsOverTime'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                selection: {
                    mode: 'xy'
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : At %x there were %y active threads"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesActiveThreadsOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotActiveThreadsOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewActiveThreadsOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Active Threads Over Time
function refreshActiveThreadsOverTime(fixTimestamps) {
    var infos = activeThreadsOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotActiveThreadsOverTime"))) {
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesActiveThreadsOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotActiveThreadsOverTime", "#overviewActiveThreadsOverTime");
        $('#footerActiveThreadsOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var timeVsThreadsInfos = {
        data: {"result": {"minY": 8137.0, "minX": 1.0, "maxY": 182065.0, "series": [{"data": [[2.0, 180007.0], [3.0, 181036.0], [4.0, 181031.0], [5.0, 180018.0], [6.0, 181032.0], [7.0, 180003.0], [8.0, 181034.0], [9.0, 181031.0], [10.0, 181015.0], [11.0, 181008.0], [12.0, 180031.0], [13.0, 180015.0], [14.0, 180013.0], [15.0, 181018.0], [16.0, 180005.0], [17.0, 181042.0], [18.0, 180016.0], [19.0, 180010.0], [20.0, 180006.0], [21.0, 180014.0], [22.0, 180015.0], [23.0, 180014.0], [24.0, 181029.0], [25.0, 182045.0], [26.0, 181022.0], [27.0, 180006.0], [28.0, 181032.0], [29.0, 181037.0], [30.0, 181039.0], [31.0, 181045.0], [33.0, 180010.0], [32.0, 181040.0], [35.0, 181014.0], [34.0, 180014.0], [37.0, 181043.0], [36.0, 181015.0], [39.0, 180018.0], [38.0, 180009.0], [41.0, 180002.0], [40.0, 181019.0], [43.0, 180014.0], [42.0, 180005.0], [45.0, 180010.0], [44.0, 180008.0], [47.0, 180012.0], [46.0, 180003.0], [49.0, 180009.0], [48.0, 180017.0], [51.0, 180004.0], [50.0, 180019.0], [53.0, 180018.0], [52.0, 180009.0], [55.0, 180014.0], [54.0, 180003.0], [57.0, 180008.0], [56.0, 180006.0], [59.0, 180016.0], [58.0, 180002.0], [61.0, 91011.0], [60.0, 180010.0], [63.0, 180004.0], [62.0, 180014.0], [67.0, 180005.0], [66.0, 180005.0], [65.0, 180019.0], [64.0, 180016.0], [71.0, 180012.0], [70.0, 181024.0], [69.0, 180006.0], [68.0, 180003.0], [75.0, 180010.0], [74.0, 180004.0], [73.0, 180011.0], [72.0, 180018.0], [79.0, 180009.0], [78.0, 180011.0], [77.0, 180009.0], [76.0, 180005.0], [83.0, 181022.0], [82.0, 180005.0], [81.0, 180004.0], [80.0, 181047.0], [87.0, 181045.0], [86.0, 180003.0], [85.0, 180011.0], [84.0, 180011.0], [91.0, 180014.0], [90.0, 180008.0], [89.0, 180003.0], [88.0, 180017.0], [93.0, 90997.5], [94.0, 61321.0], [95.0, 180005.0], [92.0, 180018.0], [96.0, 91026.0], [99.0, 180041.0], [98.0, 181041.0], [97.0, 181012.0], [100.0, 91099.0], [103.0, 180014.0], [102.0, 180007.0], [101.0, 180015.0], [107.0, 91697.0], [106.0, 181027.0], [105.0, 180023.0], [104.0, 181021.0], [111.0, 180002.0], [110.0, 181022.0], [109.0, 180003.0], [108.0, 180007.0], [113.0, 91774.5], [115.0, 180009.0], [114.0, 180008.0], [112.0, 180011.0], [117.0, 92372.0], [119.0, 182065.0], [118.0, 181030.0], [116.0, 180015.0], [120.0, 91390.5], [123.0, 91430.5], [122.0, 180016.0], [121.0, 181020.0], [126.0, 91484.5], [127.0, 180017.0], [125.0, 180006.0], [124.0, 182049.0], [135.0, 180022.0], [134.0, 180013.0], [133.0, 182048.0], [132.0, 180016.0], [131.0, 181048.0], [130.0, 180011.0], [129.0, 180015.0], [128.0, 181017.0], [139.0, 91689.0], [140.0, 91676.5], [143.0, 180012.0], [142.0, 180017.0], [141.0, 181015.0], [138.0, 180012.0], [137.0, 180012.0], [136.0, 180024.0], [144.0, 91741.5], [150.0, 91837.0], [151.0, 181037.0], [149.0, 180004.0], [148.0, 180003.0], [147.0, 180011.0], [146.0, 180016.0], [145.0, 181041.0], [153.0, 62510.333333333336], [154.0, 92408.0], [157.0, 91938.5], [159.0, 180010.0], [158.0, 180003.0], [156.0, 180016.0], [155.0, 180011.0], [152.0, 180008.0], [163.0, 92040.0], [167.0, 92091.5], [166.0, 121135.0], [165.0, 180011.0], [164.0, 180006.0], [162.0, 180007.0], [161.0, 180016.0], [160.0, 181026.0], [173.0, 62913.666666666664], [174.0, 92197.0], [175.0, 180009.0], [172.0, 180002.0], [171.0, 120113.0], [170.0, 180010.0], [169.0, 180013.0], [168.0, 180014.0], [183.0, 180023.0], [182.0, 180012.0], [181.0, 180010.0], [180.0, 180023.0], [179.0, 180004.0], [178.0, 180013.0], [177.0, 180015.0], [176.0, 120121.0], [190.0, 92431.5], [191.0, 92446.5], [189.0, 180014.0], [188.0, 180012.0], [187.0, 180010.0], [186.0, 180013.0], [185.0, 180013.0], [184.0, 180001.0], [193.0, 62491.0], [196.0, 62503.0], [199.0, 180012.0], [198.0, 180010.0], [197.0, 180002.0], [195.0, 180005.0], [194.0, 180018.0], [192.0, 120097.0], [200.0, 62530.5], [201.0, 92607.0], [203.0, 92264.0], [207.0, 180011.0], [206.0, 120109.0], [205.0, 180016.0], [204.0, 180015.0], [202.0, 120088.0], [213.0, 62837.5], [214.0, 62838.5], [215.0, 120112.0], [212.0, 120111.0], [211.0, 120148.0], [210.0, 120105.0], [209.0, 120092.0], [208.0, 180003.0], [217.0, 63354.5], [219.0, 62432.0], [223.0, 120115.0], [222.0, 120121.0], [221.0, 120116.0], [220.0, 120113.0], [218.0, 120110.0], [216.0, 120119.0], [231.0, 121136.0], [230.0, 120118.0], [229.0, 120103.0], [228.0, 120190.0], [227.0, 120078.0], [226.0, 120082.0], [225.0, 120097.0], [224.0, 120175.0], [236.0, 62995.5], [237.0, 62680.0], [239.0, 120094.0], [238.0, 120125.0], [235.0, 120122.0], [234.0, 120123.0], [233.0, 120118.0], [232.0, 120101.0], [240.0, 63007.5], [241.0, 62870.5], [247.0, 62904.0], [246.0, 120155.0], [245.0, 120117.0], [244.0, 120123.0], [243.0, 120113.0], [242.0, 120107.0], [255.0, 120105.0], [254.0, 120087.0], [253.0, 120293.0], [252.0, 120367.0], [251.0, 120450.0], [250.0, 120319.0], [249.0, 120134.0], [248.0, 120131.0], [269.0, 63339.0], [264.0, 63461.5], [263.0, 63461.5], [262.0, 121086.0], [261.0, 121152.0], [260.0, 121179.0], [266.0, 63321.5], [271.0, 120176.0], [270.0, 120120.0], [268.0, 120121.0], [259.0, 121164.0], [258.0, 120264.0], [257.0, 120115.0], [256.0, 120081.0], [267.0, 120131.0], [265.0, 120110.0], [286.0, 63526.5], [276.0, 63466.0], [277.0, 120099.0], [279.0, 120220.0], [273.0, 120140.0], [272.0, 120174.0], [275.0, 120113.0], [274.0, 120119.0], [278.0, 120108.0], [284.0, 63709.0], [287.0, 120081.0], [285.0, 120109.0], [283.0, 120128.0], [282.0, 120194.0], [281.0, 120180.0], [280.0, 120134.0], [301.0, 63816.5], [289.0, 63958.5], [291.0, 82521.33333333333], [293.0, 63708.0], [292.0, 120115.0], [294.0, 63614.5], [295.0, 120078.0], [288.0, 120128.0], [296.0, 63870.0], [297.0, 120133.0], [299.0, 120079.0], [298.0, 120138.0], [303.0, 64044.5], [302.0, 120251.0], [300.0, 120094.0], [317.0, 8137.0], [304.0, 63851.0], [305.0, 120084.0], [311.0, 120119.0], [310.0, 120107.0], [309.0, 120130.0], [308.0, 120197.0], [306.0, 45380.333333333336], [307.0, 64185.5], [314.0, 63312.0], [313.0, 120098.0], [312.0, 120083.0], [319.0, 121121.0], [318.0, 120097.0], [316.0, 120123.0], [315.0, 121095.0], [335.0, 120208.0], [330.0, 44850.0], [333.0, 64247.5], [334.0, 120229.0], [332.0, 121088.0], [323.0, 120091.0], [322.0, 120110.0], [321.0, 120088.0], [320.0, 120107.0], [331.0, 120116.0], [329.0, 120130.0], [328.0, 120123.0], [327.0, 120177.0], [326.0, 120110.0], [325.0, 120095.0], [324.0, 120112.0], [351.0, 120151.0], [343.0, 64117.5], [342.0, 120088.0], [341.0, 120097.0], [340.0, 121163.0], [346.0, 65207.5], [349.0, 63641.0], [350.0, 120120.0], [348.0, 120114.0], [339.0, 120121.0], [338.0, 120145.0], [337.0, 121172.0], [336.0, 120086.0], [347.0, 120072.0], [345.0, 120180.0], [344.0, 120118.0], [364.0, 64049.5], [360.0, 63984.0], [353.0, 65001.0], [352.0, 121142.0], [355.0, 120100.0], [354.0, 120100.0], [359.0, 120088.0], [358.0, 120092.0], [357.0, 120143.0], [356.0, 120097.0], [363.0, 64612.0], [366.0, 45615.333333333336], [367.0, 64141.0], [365.0, 120221.0], [362.0, 120175.0], [361.0, 120296.0], [381.0, 60101.0], [368.0, 64383.5], [371.0, 64260.5], [370.0, 120190.0], [369.0, 60187.0], [373.0, 36270.75], [372.0, 120157.0], [375.0, 120105.0], [374.0, 60127.0], [377.0, 64108.0], [376.0, 60188.0], [383.0, 34044.5], [382.0, 120122.0], [380.0, 120182.0], [379.0, 120176.0], [378.0, 120161.0], [398.0, 120114.0], [386.0, 64676.5], [385.0, 120186.5], [387.0, 120244.0], [391.0, 60110.0], [390.0, 120188.0], [389.0, 60104.0], [388.0, 120246.0], [396.0, 64474.5], [399.0, 60070.0], [397.0, 60078.0], [395.0, 120115.0], [394.0, 120208.0], [393.0, 120085.0], [392.0, 60079.0], [414.0, 35060.0], [406.0, 64620.0], [403.0, 26338.333333333332], [407.0, 120203.0], [401.0, 60110.0], [400.0, 60133.0], [402.0, 120118.0], [404.0, 65182.0], [405.0, 60166.0], [415.0, 120922.0], [409.0, 120595.0], [408.0, 60422.0], [413.0, 120800.0], [412.0, 120734.0], [411.0, 120980.0], [410.0, 120350.0], [430.0, 78628.33333333333], [416.0, 36494.5], [417.0, 62904.0], [419.0, 61815.0], [418.0, 65798.0], [431.0, 81462.0], [427.0, 84390.0], [426.0, 79664.0], [425.0, 83379.5], [423.0, 79282.0], [422.0, 86688.0], [421.0, 90349.0], [420.0, 77996.0], [434.0, 51963.5], [436.0, 40750.0], [437.0, 82306.0], [447.0, 11167.0], [446.0, 83084.0], [444.0, 92591.0], [435.0, 74487.0], [443.0, 91725.0], [442.0, 69242.33333333333], [439.0, 62263.0], [433.0, 77201.0], [432.0, 82909.0], [438.0, 89396.0], [462.0, 72967.0], [449.0, 57270.5], [451.0, 36263.0], [450.0, 66282.0], [453.0, 51212.5], [452.0, 71702.0], [455.0, 74698.0], [454.0, 90685.0], [457.0, 31756.333333333332], [461.0, 89195.0], [459.0, 60894.0], [458.0, 65446.0], [456.0, 69282.0], [477.0, 45567.0], [466.0, 51813.0], [471.0, 49386.5], [465.0, 93445.0], [464.0, 65820.5], [470.0, 68198.0], [469.0, 69986.0], [468.0, 77807.0], [473.0, 45936.0], [472.0, 91647.0], [476.0, 52863.5], [467.0, 92383.0], [479.0, 69689.0], [478.0, 90585.0], [475.0, 84381.0], [474.0, 92967.0], [493.0, 50359.5], [480.0, 24449.75], [482.0, 74432.0], [481.0, 89551.0], [486.0, 63093.0], [484.0, 90266.0], [487.0, 53520.5], [490.0, 31186.75], [489.0, 92275.0], [488.0, 90611.0], [495.0, 93013.0], [494.0, 94477.0], [492.0, 88911.0], [483.0, 86693.0], [491.0, 90329.0], [511.0, 88127.0], [497.0, 37762.5], [500.0, 50698.5], [503.0, 71202.5], [496.0, 91729.0], [501.0, 78097.0], [505.0, 53576.5], [509.0, 53597.0], [499.0, 90416.0], [498.0, 90366.0], [510.0, 75579.5], [507.0, 91752.0], [506.0, 69407.0], [504.0, 73510.0], [512.0, 75189.0], [520.0, 51854.0], [522.0, 94098.0], [518.0, 75074.0], [526.0, 84261.0], [524.0, 91751.0], [530.0, 53986.0], [532.0, 88115.0], [534.0, 91115.0], [528.0, 91250.0], [542.0, 96378.0], [540.0, 95697.0], [538.0, 94960.0], [546.0, 69813.0], [570.0, 64194.66666666667], [544.0, 37702.33333333333], [550.0, 52708.0], [548.0, 76211.0], [568.0, 90840.0], [552.0, 91158.0], [554.0, 14406.0], [556.0, 72867.0], [558.0, 94895.0], [564.0, 52333.5], [566.0, 53084.0], [572.0, 93963.0], [560.0, 94954.0], [562.0, 91003.0], [574.0, 91139.0], [578.0, 96835.0], [576.0, 98821.0], [582.0, 87919.0], [580.0, 89883.0], [600.0, 94601.0], [590.0, 38096.0], [588.0, 97269.0], [586.0, 84839.0], [584.0, 90849.0], [594.0, 51868.5], [596.0, 48505.0], [604.0, 11028.0], [602.0, 92934.0], [592.0, 99136.0], [606.0, 93869.0], [610.0, 38706.0], [608.0, 90784.0], [612.0, 89605.0], [614.0, 52669.0], [632.0, 96361.0], [616.0, 99420.0], [618.0, 95892.0], [620.0, 93242.0], [622.0, 77105.0], [626.0, 57852.0], [628.0, 91057.0], [630.0, 56780.0], [636.0, 96321.0], [634.0, 93745.0], [624.0, 92107.0], [638.0, 94301.0], [654.0, 101169.0], [652.0, 92396.0], [650.0, 103269.0], [648.0, 97726.0], [640.0, 94384.0], [656.0, 53813.5], [658.0, 95910.0], [660.0, 180003.0], [662.0, 102108.0], [670.0, 58082.0], [668.0, 96476.0], [664.0, 91873.0], [646.0, 79662.0], [644.0, 102700.0], [642.0, 95232.0], [678.0, 180006.0], [698.0, 123151.5], [674.0, 96340.5], [672.0, 180017.0], [676.0, 102880.0], [696.0, 70539.0], [700.0, 58449.0], [688.0, 102249.33333333334], [702.0, 81434.0], [682.0, 100089.0], [680.0, 180021.0], [684.0, 180042.0], [686.0, 120497.5], [690.0, 61697.0], [692.0, 51680.333333333336], [694.0, 66707.25], [706.0, 125026.0], [704.0, 35697.5], [708.0, 124762.0], [710.0, 124737.0], [728.0, 87145.33333333333], [716.0, 124839.5], [714.0, 121361.0], [712.0, 102219.0], [718.0, 102405.0], [726.0, 86319.0], [724.0, 124577.5], [722.0, 128287.5], [734.0, 92891.0], [720.0, 74090.25], [732.0, 89827.0], [730.0, 122278.0], [738.0, 58400.333333333336], [740.0, 126630.0], [736.0, 180021.0], [742.0, 89457.4], [750.0, 101638.75], [748.0, 91522.5], [746.0, 94312.66666666667], [744.0, 107054.0], [752.0, 102196.0], [754.0, 132817.25], [756.0, 153320.75], [758.0, 115153.8], [760.0, 86904.0], [764.0, 88157.58333333333], [762.0, 97228.83333333333], [766.0, 80102.41666666666], [798.0, 94293.71428571428], [776.0, 53981.0], [778.0, 111095.5], [780.0, 78143.75], [784.0, 77935.4], [786.0, 46881.75], [788.0, 59666.25], [790.0, 126835.0], [792.0, 117505.8], [774.0, 110907.83333333333], [772.0, 100198.6], [770.0, 117597.0], [768.0, 108318.3], [782.0, 107740.25], [796.0, 75756.4], [794.0, 111828.66666666667], [814.0, 124488.0], [824.0, 74779.16666666666], [806.0, 78667.0], [810.0, 119857.42857142858], [808.0, 93825.00000000001], [812.0, 76470.0], [800.0, 129873.25], [802.0, 142493.0], [804.0, 112465.66666666667], [818.0, 107440.0], [820.0, 113840.0], [822.0, 109241.4], [830.0, 103320.8], [828.0, 121309.75], [826.0, 52611.8], [816.0, 87376.33333333333], [834.0, 95341.5], [836.0, 106617.75], [832.0, 96205.5], [846.0, 142295.33333333334], [856.0, 138908.0], [838.0, 139952.33333333334], [858.0, 58297.50000000001], [840.0, 82442.0], [842.0, 117552.5], [844.0, 96313.5], [854.0, 138161.57142857142], [852.0, 135365.45454545453], [850.0, 118493.0], [848.0, 133381.33333333334], [860.0, 67324.33333333333], [862.0, 72077.66666666667], [864.0, 69681.0], [870.0, 76069.4], [878.0, 46561.0], [876.0, 90866.66666666667], [874.0, 68378.0], [872.0, 125425.66666666667], [866.0, 103584.8], [868.0, 60594.0], [880.0, 85329.0], [886.0, 68387.0], [884.0, 119427.5], [882.0, 117190.0], [890.0, 56437.0], [888.0, 118210.5], [892.0, 94279.66666666666], [894.0, 101086.33333333333], [910.0, 77805.0], [902.0, 45883.75], [900.0, 119877.5], [898.0, 82702.0], [920.0, 149478.2], [922.0, 38282.333333333336], [906.0, 117470.57142857143], [904.0, 69263.0], [908.0, 110440.5], [896.0, 113402.8], [912.0, 142208.3], [914.0, 41589.0], [916.0, 160283.7142857143], [918.0, 147562.8], [926.0, 105822.75], [924.0, 136195.33333333334], [930.0, 83208.33333333333], [934.0, 36778.0], [952.0, 132280.0], [928.0, 134894.0], [932.0, 131309.4], [942.0, 76241.33333333333], [940.0, 91375.66666666667], [938.0, 105879.25], [936.0, 134858.33333333334], [954.0, 102011.75], [944.0, 134791.0], [946.0, 87646.33333333333], [948.0, 115836.25], [950.0, 82735.0], [958.0, 105417.75], [956.0, 129094.33333333333], [962.0, 113992.0], [960.0, 37775.0], [964.0, 78778.0], [966.0, 95398.83333333334], [974.0, 114848.5], [972.0, 117742.5], [970.0, 47989.5], [968.0, 117809.0], [976.0, 46586.0], [978.0, 94445.66666666667], [980.0, 58834.6], [982.0, 67894.0], [990.0, 89178.83333333333], [988.0, 58620.2], [986.0, 131920.0], [984.0, 100480.0], [994.0, 71325.6], [996.0, 59950.77777777778], [1000.0, 32051.443037974685], [1004.0, 85493.66666666666], [1002.0, 61346.0], [1006.0, 78039.75], [1010.0, 54890.100000000006], [1008.0, 85639.33333333334], [1018.0, 67797.0], [1016.0, 78413.5], [1020.0, 74489.66666666667], [1022.0, 56358.0], [1012.0, 68316.5], [1014.0, 41151.0], [998.0, 71957.28571428571], [992.0, 69802.8], [1036.0, 43712.0], [1076.0, 69523.25], [1084.0, 60774.0], [1072.0, 143269.0], [1080.0, 175988.0], [1028.0, 127288.0], [1024.0, 93433.33333333334], [1032.0, 127216.5], [1052.0, 113907.0], [1048.0, 125429.0], [1044.0, 107916.5], [1040.0, 133301.5], [1060.0, 81342.0], [1064.0, 88691.33333333334], [1068.0, 116074.5], [1056.0, 44626.0], [1096.0, 91737.66666666667], [1136.0, 63721.25], [1116.0, 69795.4], [1088.0, 120638.0], [1092.0, 111250.25], [1100.0, 131893.0], [1140.0, 124079.0], [1120.0, 87166.0], [1124.0, 73029.2], [1148.0, 73355.0], [1144.0, 180015.5], [1128.0, 67235.4], [1132.0, 125313.5], [1104.0, 99098.66666666667], [1108.0, 71167.5], [1112.0, 31174.666666666664], [1152.0, 180002.0], [1204.0, 174977.75], [1164.0, 119161.33333333333], [1168.0, 119609.2], [1172.0, 175136.0], [1176.0, 138094.5], [1156.0, 180008.0], [1160.0, 180018.0], [1180.0, 54525.0], [1212.0, 180007.0], [1184.0, 64902.4], [1188.0, 119808.8], [1192.0, 120845.0], [1196.0, 141083.33333333334], [1208.0, 158582.66666666666], [1200.0, 125642.5], [1276.0, 64367.4], [1272.0, 96770.66666666667], [1248.0, 71394.66666666667], [1252.0, 94598.33333333333], [1256.0, 97432.33333333333], [1260.0, 98297.66666666667], [1268.0, 63444.8], [1264.0, 90668.33333333334], [1244.0, 100937.33333333334], [1216.0, 155978.75], [1220.0, 161301.4], [1224.0, 105763.0], [1228.0, 81975.83333333333], [1240.0, 116429.0], [1236.0, 89322.5], [1232.0, 89798.0], [1292.0, 119444.66666666666], [1328.0, 87371.6], [1280.0, 94891.33333333333], [1284.0, 116379.0], [1288.0, 117826.0], [1332.0, 54135.75], [1336.0, 61388.2], [1312.0, 101709.66666666667], [1340.0, 45310.5], [1296.0, 160567.33333333334], [1300.0, 152007.0], [1304.0, 87230.8], [1308.0, 109952.2], [1316.0, 138356.5], [1320.0, 101763.4], [1324.0, 99045.0], [1352.0, 130493.5], [1400.0, 45964.0], [1396.0, 56340.4], [1344.0, 114324.0], [1348.0, 76444.33333333333], [1372.0, 98961.75], [1356.0, 144722.11111111112], [1392.0, 89097.85714285714], [1404.0, 103572.66666666666], [1376.0, 101819.66666666666], [1384.0, 91482.44444444444], [1380.0, 126648.4], [1388.0, 85922.875], [1360.0, 54332.0], [1364.0, 61355.75], [1368.0, 129979.5], [1416.0, 83692.42857142857], [1420.0, 77031.88888888889], [1408.0, 67608.5], [1436.0, 122688.4], [1432.0, 132024.0], [1412.0, 82662.88888888888], [1440.0, 104854.66666666667], [1444.0, 57605.727272727265], [1468.0, 25662.863013698636], [1464.0, 100692.0], [1460.0, 117447.375], [1456.0, 79356.55555555556], [1448.0, 56276.66666666667], [1452.0, 125110.33333333333], [1424.0, 109851.0], [1428.0, 130744.66666666667], [1472.0, 119622.4], [1476.0, 123393.25], [1500.0, 76007.5625], [1496.0, 102737.85714285713], [1492.0, 117920.0], [1488.0, 106672.2], [1480.0, 86164.0], [1484.0, 101663.5], [1520.0, 120004.0], [1524.0, 124923.5], [1528.0, 62902.0], [1532.0, 98458.5], [1504.0, 107617.59999999999], [1508.0, 128262.8], [1512.0, 120004.0], [1516.0, 124457.33333333333], [1548.0, 43907.16666666667], [1536.0, 141692.0], [1540.0, 35483.0], [1544.0, 98024.6], [1568.0, 76499.8], [1572.0, 81335.0], [1592.0, 64007.75], [1588.0, 35719.555555555555], [1584.0, 55312.2], [1596.0, 120010.5], [1576.0, 86408.0], [1580.0, 120009.0], [1564.0, 36759.0], [1560.0, 126034.33333333333], [1556.0, 93401.0], [1552.0, 73933.0], [1648.0, 180009.5], [1604.0, 41137.3], [1608.0, 93127.5], [1612.0, 180009.0], [1600.0, 51411.142857142855], [1636.0, 180014.0], [1632.0, 120011.0], [1640.0, 180011.0], [1644.0, 180016.0], [1660.0, 120003.0], [1656.0, 150004.5], [1620.0, 109892.0], [1616.0, 120003.0], [1628.0, 120013.0], [1624.0, 120003.0], [1672.0, 120005.0], [1680.0, 150009.5], [1664.0, 120015.0], [1668.0, 120016.0], [1692.0, 111410.5], [1684.0, 172846.0], [1700.0, 112874.0], [1724.0, 180021.0], [1704.0, 120007.5], [1708.0, 113478.33333333333], [1676.0, 120014.0], [1716.0, 140014.33333333334], [1740.0, 140018.33333333334], [1728.0, 120011.0], [1732.0, 120037.0], [1736.0, 120009.0], [1764.0, 120011.0], [1760.0, 108081.0], [1788.0, 167323.0], [1776.0, 129216.75], [1780.0, 120009.5], [1784.0, 120003.0], [1768.0, 120012.0], [1772.0, 120003.0], [1744.0, 120006.33333333333], [1752.0, 120005.33333333333], [1748.0, 120011.0], [1756.0, 109142.0], [1796.0, 111083.6], [1792.0, 120024.0], [1053.0, 127941.5], [1049.0, 70397.75], [1045.0, 101855.0], [1041.0, 123944.0], [1025.0, 127729.5], [1069.0, 92337.5], [1065.0, 61430.5], [1061.0, 84934.66666666666], [1057.0, 92353.33333333334], [1073.0, 44515.0], [1037.0, 140315.33333333334], [1033.0, 61213.6], [1029.0, 119499.0], [1077.0, 121439.66666666667], [1085.0, 115056.0], [1081.0, 83966.66666666666], [1101.0, 103528.25], [1097.0, 103190.2], [1089.0, 128938.5], [1093.0, 105042.25], [1137.0, 119235.66666666667], [1141.0, 65123.0], [1121.0, 84900.5], [1149.0, 180018.5], [1145.0, 135076.0], [1125.0, 100348.0], [1129.0, 180023.0], [1133.0, 116901.66666666667], [1109.0, 117718.0], [1105.0, 119535.0], [1113.0, 93856.33333333334], [1117.0, 125558.6], [1205.0, 123384.0], [1153.0, 146148.2], [1181.0, 92773.5], [1177.0, 42144.0], [1173.0, 180022.0], [1169.0, 120205.66666666667], [1213.0, 151311.5], [1185.0, 76061.5], [1189.0, 142752.0], [1193.0, 135952.33333333334], [1209.0, 158468.66666666666], [1201.0, 138598.5], [1165.0, 174124.0], [1161.0, 180017.0], [1157.0, 133945.0], [1197.0, 86189.33333333333], [1277.0, 76087.2], [1269.0, 98532.33333333333], [1261.0, 75549.0], [1249.0, 113566.4], [1253.0, 138947.33333333334], [1257.0, 138874.0], [1273.0, 168307.0], [1265.0, 104676.0], [1245.0, 58666.0], [1225.0, 123118.33333333333], [1221.0, 46755.5], [1217.0, 88761.28571428571], [1229.0, 138826.0], [1241.0, 102867.6], [1237.0, 117656.5], [1233.0, 114563.5], [1285.0, 53900.8], [1333.0, 105240.75], [1341.0, 59696.5], [1281.0, 135975.0], [1329.0, 116539.66666666667], [1293.0, 155632.25], [1289.0, 155995.66666666666], [1337.0, 84506.0], [1305.0, 48051.5], [1301.0, 89568.18181818182], [1297.0, 104267.4], [1309.0, 64821.0], [1313.0, 106374.25], [1321.0, 63559.0], [1325.0, 109750.0], [1317.0, 110652.4], [1357.0, 130380.46153846153], [1349.0, 102329.25], [1345.0, 75579.33333333333], [1353.0, 140579.0], [1373.0, 113291.33333333333], [1393.0, 96424.2], [1397.0, 113260.33333333333], [1405.0, 63344.0], [1401.0, 48406.75], [1385.0, 110591.85714285714], [1381.0, 52313.2], [1377.0, 80265.11111111111], [1389.0, 110963.33333333333], [1361.0, 126985.16666666666], [1365.0, 82874.4], [1369.0, 75694.0], [1465.0, 53518.899999999994], [1417.0, 69500.57142857143], [1413.0, 54311.0], [1409.0, 95501.16666666666], [1437.0, 92561.4], [1433.0, 143577.75], [1445.0, 73394.0], [1441.0, 73485.81818181818], [1469.0, 132006.0], [1461.0, 60583.875], [1457.0, 63198.0], [1421.0, 71263.2], [1453.0, 100664.6], [1449.0, 65132.80000000001], [1425.0, 91454.0], [1429.0, 88078.75], [1481.0, 112390.5], [1485.0, 118031.83333333333], [1477.0, 80558.33333333333], [1501.0, 29385.083333333325], [1493.0, 117821.625], [1489.0, 144715.0], [1497.0, 97806.57142857143], [1473.0, 103027.57142857142], [1521.0, 120005.0], [1525.0, 52205.333333333336], [1529.0, 120008.0], [1533.0, 129121.25], [1505.0, 145539.0], [1509.0, 109568.66666666667], [1513.0, 120004.0], [1517.0, 124549.5], [1549.0, 86349.2], [1537.0, 68605.5], [1541.0, 49453.0], [1545.0, 52637.66666666667], [1569.0, 80010.33333333333], [1573.0, 78596.6], [1593.0, 81353.83333333333], [1589.0, 140005.0], [1585.0, 68760.0], [1597.0, 73844.0], [1577.0, 101699.0], [1581.0, 46757.333333333336], [1561.0, 66354.25], [1557.0, 47310.5], [1553.0, 85094.0], [1565.0, 113092.66666666667], [1601.0, 120011.5], [1657.0, 120004.0], [1605.0, 73112.66666666667], [1609.0, 75330.5], [1613.0, 120013.0], [1629.0, 120004.0], [1625.0, 120010.0], [1617.0, 120012.0], [1621.0, 120008.0], [1633.0, 120015.0], [1637.0, 180015.0], [1641.0, 180011.0], [1645.0, 180011.0], [1661.0, 120002.0], [1653.0, 120014.2], [1677.0, 112039.0], [1669.0, 120012.0], [1665.0, 120004.0], [1673.0, 120005.0], [1693.0, 170322.0], [1689.0, 112033.0], [1713.0, 111048.0], [1717.0, 120006.0], [1721.0, 117669.0], [1725.0, 120003.0], [1685.0, 175730.5], [1681.0, 120012.0], [1701.0, 114570.6], [1705.0, 122543.33333333333], [1709.0, 120008.0], [1733.0, 107476.0], [1785.0, 120007.0], [1729.0, 120013.75], [1741.0, 120009.6], [1737.0, 120010.0], [1745.0, 120007.0], [1749.0, 120019.0], [1753.0, 140010.33333333334], [1757.0, 120012.0], [1761.0, 120012.0], [1789.0, 120013.33333333333], [1777.0, 120003.0], [1781.0, 120015.0], [1765.0, 120009.0], [1769.0, 120009.0], [1773.0, 120012.0], [1793.0, 113761.0], [1797.0, 117968.0], [513.0, 92257.0], [537.0, 65443.333333333336], [521.0, 93966.0], [523.0, 31893.0], [527.0, 42101.5], [517.0, 84008.5], [515.0, 78749.5], [519.0, 77033.0], [525.0, 94676.0], [529.0, 37592.66666666667], [531.0, 81847.0], [533.0, 95004.0], [535.0, 92843.0], [543.0, 95373.0], [541.0, 85929.0], [539.0, 95344.0], [547.0, 89969.0], [549.0, 90802.0], [545.0, 97201.0], [551.0, 89778.0], [553.0, 53169.0], [557.0, 55851.0], [555.0, 94420.5], [559.0, 99213.0], [565.0, 93214.0], [567.0, 39766.0], [573.0, 53058.5], [571.0, 96699.0], [575.0, 85443.0], [561.0, 73803.0], [563.0, 94177.0], [579.0, 92434.0], [601.0, 55093.0], [577.0, 54052.0], [583.0, 93945.0], [589.0, 86153.0], [587.0, 77270.0], [585.0, 92556.0], [591.0, 55243.0], [593.0, 51769.5], [595.0, 95955.0], [599.0, 96358.5], [597.0, 92494.0], [603.0, 93335.0], [605.0, 96706.0], [607.0, 94619.0], [609.0, 90006.0], [633.0, 41534.66666666667], [613.0, 39742.66666666667], [611.0, 90256.0], [615.0, 95265.0], [617.0, 55931.0], [619.0, 93486.0], [621.0, 80403.0], [623.0, 95874.0], [627.0, 52559.0], [629.0, 97022.0], [631.0, 55250.0], [637.0, 53326.5], [635.0, 96495.0], [639.0, 101013.0], [625.0, 99482.0], [667.0, 71292.5], [671.0, 180029.0], [641.0, 52543.0], [653.0, 98451.0], [651.0, 80466.0], [649.0, 100960.0], [655.0, 95872.0], [657.0, 94976.0], [659.0, 53712.0], [661.0, 67899.66666666666], [663.0, 39918.0], [669.0, 180003.0], [665.0, 94895.0], [647.0, 180025.0], [645.0, 96321.0], [643.0, 180019.0], [679.0, 70948.0], [689.0, 59711.33333333333], [673.0, 96838.5], [677.0, 42066.0], [675.0, 100280.0], [697.0, 84335.33333333333], [699.0, 126501.5], [703.0, 86369.0], [701.0, 83895.0], [683.0, 97844.0], [681.0, 99460.0], [685.0, 60255.16666666667], [687.0, 56664.66666666667], [691.0, 72336.5], [693.0, 35018.0], [695.0, 125320.5], [707.0, 87422.66666666666], [731.0, 68433.0], [705.0, 124353.5], [709.0, 79822.0], [711.0, 81096.0], [717.0, 53467.5], [715.0, 75118.0], [713.0, 72147.75], [719.0, 79174.5], [721.0, 86043.0], [727.0, 65898.0], [725.0, 122708.0], [723.0, 80666.5], [733.0, 49457.5], [735.0, 105092.0], [729.0, 55065.0], [737.0, 105446.0], [761.0, 90838.75], [741.0, 97645.75000000001], [739.0, 73254.0], [751.0, 114611.0], [749.0, 94617.33333333333], [747.0, 120400.0], [745.0, 115213.0], [743.0, 68232.14285714287], [753.0, 70351.14285714286], [757.0, 87346.0], [755.0, 106981.0], [759.0, 85096.33333333333], [763.0, 91366.16666666666], [767.0, 119860.07692307692], [765.0, 105830.42857142857], [799.0, 110080.0], [797.0, 86601.0], [781.0, 87285.25], [777.0, 77898.75], [779.0, 92661.5], [785.0, 69641.16666666666], [787.0, 66363.0], [789.0, 80343.75], [791.0, 53964.83333333333], [793.0, 104879.66666666669], [775.0, 80274.25], [773.0, 94845.62500000001], [771.0, 121147.66666666667], [769.0, 87238.42857142858], [783.0, 76644.0], [795.0, 155200.25], [815.0, 77916.5], [807.0, 125824.0], [811.0, 83886.14285714286], [809.0, 78949.66666666666], [813.0, 96159.5], [801.0, 135115.0], [803.0, 98374.0], [805.0, 108860.66666666666], [817.0, 107488.42857142858], [819.0, 68141.4], [823.0, 101113.0], [821.0, 72727.25], [829.0, 70263.33333333334], [827.0, 108701.0], [825.0, 124600.5], [831.0, 79877.25], [833.0, 118285.5], [859.0, 64663.2], [847.0, 115201.0], [835.0, 104946.66666666666], [845.0, 102753.5], [839.0, 119691.0], [837.0, 76252.33333333333], [857.0, 53497.5], [841.0, 97644.0], [843.0, 53080.0], [853.0, 110967.0], [851.0, 70308.0], [849.0, 129855.42857142858], [855.0, 102709.0], [861.0, 71828.0], [863.0, 80510.75], [867.0, 91860.8], [865.0, 88471.75], [879.0, 74075.5], [877.0, 117841.5], [875.0, 69228.5], [873.0, 89774.0], [869.0, 55470.75], [887.0, 27955.75], [885.0, 69422.5], [883.0, 76578.66666666666], [881.0, 118357.0], [891.0, 49965.0], [889.0, 37584.0], [871.0, 108613.25], [893.0, 81591.5], [895.0, 146907.8], [897.0, 125773.7], [923.0, 117199.0], [901.0, 55182.66666666667], [899.0, 53410.0], [903.0, 80092.33333333334], [921.0, 87914.66666666667], [905.0, 119827.5], [907.0, 119521.0], [909.0, 118912.0], [911.0, 99668.5], [927.0, 31637.333333333332], [913.0, 54423.0], [915.0, 115595.5], [917.0, 96616.5], [919.0, 82949.66666666666], [925.0, 139743.5], [929.0, 75119.0], [953.0, 89462.4], [933.0, 69936.5], [935.0, 118625.2], [943.0, 55106.33333333333], [931.0, 129879.0], [941.0, 141800.25], [939.0, 142688.0], [937.0, 132770.66666666666], [955.0, 47320.0], [959.0, 82578.33333333334], [945.0, 126898.6], [947.0, 116541.5], [949.0, 104932.25], [951.0, 143256.0], [957.0, 152160.6666666667], [963.0, 150563.75], [987.0, 65205.75], [991.0, 77155.0], [961.0, 102192.33333333333], [965.0, 110347.0], [975.0, 135495.0], [973.0, 135635.22222222222], [971.0, 116040.0], [969.0, 90746.0], [967.0, 104011.5], [977.0, 87447.5], [979.0, 76337.85714285713], [983.0, 89565.33333333333], [981.0, 102013.33333333334], [989.0, 62509.0], [985.0, 47301.66666666667], [997.0, 71214.14285714286], [999.0, 61236.28571428571], [993.0, 81918.75], [1001.0, 106540.33333333334], [1003.0, 41098.666666666664], [1005.0, 89207.0], [1007.0, 43501.333333333336], [1009.0, 110198.0], [1017.0, 180019.5], [1019.0, 53679.5], [1023.0, 180011.66666666666], [1021.0, 172909.0], [1011.0, 44841.0], [1013.0, 109644.0], [1015.0, 118823.0], [995.0, 42338.11111111111], [1030.0, 54263.333333333336], [1034.0, 68796.5], [1038.0, 73075.0], [1074.0, 42459.5], [1078.0, 49710.0], [1082.0, 121694.5], [1026.0, 67037.5], [1054.0, 62067.333333333336], [1050.0, 85743.5], [1046.0, 87620.66666666666], [1042.0, 119768.0], [1066.0, 67325.75], [1062.0, 143989.0], [1070.0, 33491.666666666664], [1086.0, 53109.333333333336], [1058.0, 136944.66666666666], [1094.0, 180012.0], [1090.0, 91811.0], [1114.0, 65320.428571428565], [1118.0, 124615.0], [1098.0, 92610.66666666667], [1102.0, 180006.0], [1138.0, 88620.0], [1142.0, 71748.0], [1122.0, 96439.5], [1126.0, 131637.5], [1150.0, 131336.5], [1146.0, 110304.5], [1130.0, 60479.0], [1134.0, 65843.75], [1106.0, 96910.0], [1110.0, 113072.0], [1154.0, 173030.5], [1162.0, 92826.25], [1166.0, 134211.5], [1170.0, 137791.5], [1174.0, 153216.75], [1182.0, 112643.0], [1158.0, 118902.0], [1178.0, 127758.66666666667], [1214.0, 118158.66666666666], [1210.0, 180013.0], [1186.0, 161606.66666666666], [1190.0, 119585.0], [1194.0, 137316.66666666666], [1198.0, 174144.0], [1206.0, 155900.66666666666], [1202.0, 180006.66666666666], [1278.0, 105271.25], [1262.0, 75213.5], [1266.0, 88600.0], [1250.0, 96216.0], [1254.0, 98315.33333333333], [1258.0, 69082.75], [1274.0, 82859.16666666666], [1270.0, 61617.666666666664], [1246.0, 113631.0], [1218.0, 180013.33333333334], [1226.0, 97742.0], [1222.0, 141463.0], [1230.0, 88686.4], [1242.0, 123073.66666666667], [1238.0, 77195.0], [1234.0, 116746.0], [1294.0, 110015.0], [1338.0, 66183.16666666667], [1310.0, 143406.8], [1282.0, 173541.5], [1286.0, 164395.5], [1290.0, 123553.66666666667], [1330.0, 74258.33333333333], [1334.0, 61745.0], [1342.0, 102749.0], [1298.0, 54123.0], [1302.0, 123629.33333333333], [1306.0, 85386.0], [1314.0, 91077.6], [1318.0, 65418.6], [1326.0, 82744.5], [1322.0, 112285.25], [1354.0, 45521.166666666664], [1350.0, 87096.25], [1374.0, 101098.75], [1346.0, 61534.25], [1358.0, 99299.33333333333], [1394.0, 129227.75], [1398.0, 150862.14285714284], [1406.0, 128634.75], [1402.0, 56122.75], [1382.0, 72403.0], [1378.0, 111693.14285714286], [1386.0, 81388.5], [1390.0, 59180.75], [1362.0, 50812.0], [1366.0, 73671.33333333333], [1370.0, 127834.85714285714], [1414.0, 112451.0], [1410.0, 106857.38461538461], [1438.0, 82205.66666666667], [1434.0, 107148.5], [1430.0, 57592.0], [1418.0, 61903.25], [1442.0, 71395.28571428571], [1470.0, 110245.83333333333], [1462.0, 58334.77777777778], [1458.0, 102600.5], [1422.0, 63713.333333333336], [1466.0, 57397.444444444445], [1446.0, 91925.85714285714], [1450.0, 70308.83333333333], [1454.0, 129089.0], [1426.0, 71860.33333333333], [1478.0, 101611.6], [1474.0, 112239.5], [1502.0, 120002.0], [1498.0, 105940.2], [1494.0, 82318.5], [1490.0, 116672.0], [1482.0, 88523.14285714287], [1486.0, 113017.0], [1522.0, 120012.0], [1526.0, 70085.75], [1530.0, 137507.2], [1506.0, 150007.0], [1534.0, 120007.0], [1514.0, 138512.6], [1510.0, 127432.0], [1518.0, 68300.5], [1550.0, 135045.0], [1542.0, 92822.75], [1538.0, 72213.25], [1546.0, 87945.8], [1570.0, 51846.333333333336], [1574.0, 101630.5], [1594.0, 47020.307692307695], [1590.0, 72158.0], [1586.0, 35497.90909090909], [1598.0, 57274.75], [1578.0, 93441.6], [1582.0, 120008.0], [1562.0, 120224.0], [1558.0, 89665.22222222222], [1554.0, 58914.0], [1566.0, 18127.0], [1658.0, 120019.0], [1614.0, 160009.33333333334], [1606.0, 59335.75], [1610.0, 60989.75], [1602.0, 122310.5], [1638.0, 141929.5], [1634.0, 180022.0], [1642.0, 180011.0], [1646.0, 180014.0], [1662.0, 120010.0], [1654.0, 120003.0], [1618.0, 120011.0], [1622.0, 150018.0], [1630.0, 120014.0], [1626.0, 120019.0], [1670.0, 120019.0], [1674.0, 150006.0], [1682.0, 150010.5], [1694.0, 120010.0], [1666.0, 120012.0], [1690.0, 110963.0], [1686.0, 169628.0], [1698.0, 169820.0], [1702.0, 110036.0], [1726.0, 120003.0], [1718.0, 120003.66666666667], [1722.0, 120007.5], [1706.0, 115901.33333333334], [1714.0, 110748.0], [1678.0, 180007.0], [1742.0, 116413.5], [1734.0, 120004.66666666667], [1730.0, 120012.0], [1738.0, 120006.0], [1762.0, 120004.0], [1766.0, 120006.0], [1790.0, 120016.5], [1778.0, 106069.0], [1782.0, 120010.0], [1786.0, 120003.66666666667], [1770.0, 120009.0], [1774.0, 120017.0], [1746.0, 116209.5], [1750.0, 120009.0], [1754.0, 120004.0], [1758.0, 120014.0], [1794.0, 150010.0], [1039.0, 105981.8], [1079.0, 72774.0], [1027.0, 122997.33333333333], [1047.0, 54537.0], [1043.0, 70980.5], [1051.0, 126249.5], [1055.0, 114624.33333333333], [1067.0, 93188.66666666666], [1063.0, 130802.0], [1059.0, 180010.0], [1071.0, 130736.0], [1075.0, 93449.8], [1035.0, 174054.5], [1031.0, 180004.5], [1087.0, 51317.333333333336], [1083.0, 72970.5], [1103.0, 39597.0], [1095.0, 82028.5], [1099.0, 88362.66666666666], [1091.0, 87715.2], [1119.0, 61084.66666666667], [1139.0, 127548.0], [1143.0, 143229.66666666666], [1123.0, 180006.0], [1151.0, 136989.0], [1147.0, 79506.33333333334], [1127.0, 111615.25], [1131.0, 78608.5], [1135.0, 93899.0], [1111.0, 83648.5], [1107.0, 175044.0], [1115.0, 97071.0], [1207.0, 159312.66666666666], [1183.0, 68421.0], [1179.0, 113185.5], [1175.0, 128728.5], [1171.0, 64763.5], [1215.0, 180008.0], [1187.0, 100774.66666666667], [1191.0, 140517.33333333334], [1195.0, 145718.66666666666], [1211.0, 89969.33333333333], [1203.0, 157722.5], [1167.0, 82053.0], [1163.0, 180012.33333333334], [1159.0, 172110.5], [1155.0, 96924.75], [1199.0, 117502.0], [1251.0, 87548.6], [1259.0, 77496.75], [1263.0, 76849.25], [1279.0, 103301.75], [1255.0, 98888.66666666667], [1275.0, 74396.75], [1271.0, 83687.25], [1267.0, 104351.5], [1247.0, 82037.4], [1219.0, 115301.0], [1223.0, 56669.0], [1231.0, 118096.5], [1227.0, 133972.5], [1243.0, 128757.66666666667], [1239.0, 77390.33333333333], [1235.0, 115567.5], [1291.0, 119705.33333333333], [1283.0, 87971.8], [1335.0, 42026.2], [1331.0, 109376.66666666667], [1295.0, 92314.0], [1287.0, 59516.0], [1339.0, 75507.66666666667], [1303.0, 122525.66666666667], [1299.0, 158490.0], [1307.0, 106804.0], [1311.0, 109244.75], [1343.0, 65143.66666666667], [1323.0, 98846.0], [1327.0, 108671.75], [1319.0, 102280.6], [1315.0, 135784.33333333334], [1359.0, 119225.5], [1355.0, 108033.55555555556], [1351.0, 60063.5], [1347.0, 140842.0], [1375.0, 72043.4], [1371.0, 87261.0], [1395.0, 86092.00000000001], [1399.0, 130220.5], [1407.0, 107555.28571428571], [1403.0, 49453.625], [1383.0, 108493.66666666667], [1379.0, 105296.25], [1387.0, 118713.83333333334], [1391.0, 98274.5], [1363.0, 89868.75], [1367.0, 86613.85714285713], [1411.0, 87302.79999999999], [1439.0, 68984.0], [1435.0, 63582.33333333333], [1431.0, 86445.6], [1415.0, 128332.25], [1419.0, 83838.5], [1443.0, 124717.66666666667], [1471.0, 98901.125], [1467.0, 48666.99999999999], [1463.0, 83080.66666666667], [1459.0, 42507.833333333336], [1423.0, 52172.75], [1451.0, 102343.5], [1455.0, 59225.545454545456], [1447.0, 87035.33333333333], [1427.0, 72288.42857142858], [1475.0, 111810.0], [1503.0, 165007.25], [1499.0, 73146.33333333333], [1495.0, 98756.14285714286], [1491.0, 96443.55555555556], [1479.0, 62911.0], [1483.0, 140892.0], [1487.0, 150005.0], [1523.0, 127866.0], [1527.0, 133681.875], [1531.0, 160005.33333333334], [1535.0, 68805.0], [1507.0, 100310.75], [1515.0, 70600.0], [1511.0, 127861.5], [1519.0, 120003.0], [1595.0, 75646.33333333333], [1547.0, 93134.25], [1551.0, 66547.45454545454], [1539.0, 29292.666666666668], [1543.0, 30534.249999999996], [1571.0, 129595.66666666667], [1591.0, 120006.5], [1587.0, 42032.22222222222], [1599.0, 104270.6], [1575.0, 36143.07142857143], [1579.0, 120005.5], [1583.0, 100939.25], [1563.0, 124216.5], [1559.0, 42895.25], [1555.0, 105374.66666666666], [1567.0, 102000.25], [1607.0, 59951.0], [1611.0, 120011.0], [1603.0, 122419.0], [1631.0, 120002.0], [1627.0, 120005.0], [1615.0, 150007.0], [1619.0, 132676.66666666666], [1623.0, 180015.0], [1663.0, 120017.0], [1635.0, 180016.0], [1639.0, 180006.0], [1643.0, 180015.0], [1647.0, 180015.0], [1659.0, 120010.0], [1655.0, 120011.0], [1715.0, 120004.5], [1699.0, 113230.0], [1675.0, 154301.0], [1671.0, 150012.5], [1667.0, 120002.0], [1679.0, 120016.0], [1719.0, 115147.5], [1727.0, 120011.0], [1723.0, 110489.0], [1683.0, 120006.0], [1687.0, 180007.0], [1711.0, 120013.0], [1735.0, 120009.0], [1731.0, 120016.5], [1739.0, 120014.0], [1743.0, 120016.5], [1747.0, 120003.0], [1751.0, 120004.0], [1755.0, 120009.0], [1759.0, 120021.0], [1791.0, 120013.0], [1787.0, 120010.0], [1779.0, 120003.0], [1783.0, 120008.0], [1763.0, 120013.0], [1767.0, 120003.0], [1771.0, 120002.5], [1795.0, 120012.0], [1.0, 180005.0]], "isOverall": false, "label": "HTTP Request", "isController": false}, {"data": [[1077.1605004468288, 90738.56890080418]], "isOverall": false, "label": "HTTP Request-Aggregated", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 1797.0, "title": "Time VS Threads"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: { noColumns: 2,show: true, container: '#legendTimeVsThreads' },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s: At %x.2 active threads, Average response time was %y.2 ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesTimeVsThreads"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotTimesVsThreads"), dataset, options);
            // setup overview
            $.plot($("#overviewTimesVsThreads"), dataset, prepareOverviewOptions(options));
        }
};

// Time vs threads
function refreshTimeVsThreads(){
    var infos = timeVsThreadsInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTimeVsThreads");
        return;
    }
    if(isGraph($("#flotTimesVsThreads"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTimeVsThreads");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTimesVsThreads", "#overviewTimesVsThreads");
        $('#footerTimeVsThreads .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var bytesThroughputOverTimeInfos = {
        data : {"result": {"minY": 228.8, "minX": 1.69659612E12, "maxY": 3587.2, "series": [{"data": [[1.69659624E12, 2095.6], [1.69659642E12, 3587.2], [1.69659612E12, 458.4], [1.6965966E12, 766.2], [1.6965963E12, 1300.95], [1.69659648E12, 1938.6], [1.69659618E12, 1519.1], [1.69659666E12, 440.0], [1.69659636E12, 3493.05], [1.69659654E12, 2708.4]], "isOverall": false, "label": "Bytes received per second", "isController": false}, {"data": [[1.69659624E12, 1947.4], [1.69659642E12, 2680.6], [1.69659612E12, 496.6], [1.6965966E12, 517.4], [1.6965963E12, 722.8], [1.69659648E12, 1973.4], [1.69659618E12, 1640.6], [1.69659666E12, 228.8], [1.69659636E12, 1996.8], [1.69659654E12, 2342.6]], "isOverall": false, "label": "Bytes sent per second", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69659666E12, "title": "Bytes Throughput Over Time"}},
        getOptions : function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity) ,
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Bytes / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendBytesThroughputOverTime'
                },
                selection: {
                    mode: "xy"
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y"
                }
            };
        },
        createGraph : function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesBytesThroughputOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotBytesThroughputOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewBytesThroughputOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Bytes throughput Over Time
function refreshBytesThroughputOverTime(fixTimestamps) {
    var infos = bytesThroughputOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotBytesThroughputOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesBytesThroughputOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotBytesThroughputOverTime", "#overviewBytesThroughputOverTime");
        $('#footerBytesThroughputOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimesOverTimeInfos = {
        data: {"result": {"minY": 9772.92146596859, "minX": 1.69659612E12, "maxY": 180322.86363636353, "series": [{"data": [[1.69659624E12, 52493.544726301734], [1.69659642E12, 106768.25800193977], [1.69659612E12, 9772.92146596859], [1.6965966E12, 153695.48241206032], [1.6965963E12, 132882.47122302145], [1.69659648E12, 61924.12121212126], [1.69659618E12, 35802.730586370824], [1.69659666E12, 180322.86363636353], [1.69659636E12, 129821.81250000001], [1.69659654E12, 115127.30632630414]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69659666E12, "title": "Response Time Over Time"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average response time was %y ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Times Over Time
function refreshResponseTimeOverTime(fixTimestamps) {
    var infos = responseTimesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimesOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesOverTime", "#overviewResponseTimesOverTime");
        $('#footerResponseTimesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var latenciesOverTimeInfos = {
        data: {"result": {"minY": 9772.732984293203, "minX": 1.69659612E12, "maxY": 180322.86363636353, "series": [{"data": [[1.69659624E12, 52493.46461949275], [1.69659642E12, 106768.20077594563], [1.69659612E12, 9772.732984293203], [1.6965966E12, 153695.42713567836], [1.6965963E12, 132882.3992805755], [1.69659648E12, 61924.069828721986], [1.69659618E12, 35802.65768621234], [1.69659666E12, 180322.86363636353], [1.69659636E12, 129821.75651041645], [1.69659654E12, 115127.27413984449]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69659666E12, "title": "Latencies Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response latencies in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendLatenciesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average latency was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesLatenciesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotLatenciesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewLatenciesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Latencies Over Time
function refreshLatenciesOverTime(fixTimestamps) {
    var infos = latenciesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyLatenciesOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotLatenciesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesLatenciesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotLatenciesOverTime", "#overviewLatenciesOverTime");
        $('#footerLatenciesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var connectTimeOverTimeInfos = {
        data: {"result": {"minY": 2.3522727272727275, "minX": 1.69659612E12, "maxY": 16.068062827225116, "series": [{"data": [[1.69659624E12, 2.9212283044058767], [1.69659642E12, 2.546071774975753], [1.69659612E12, 16.068062827225116], [1.6965966E12, 2.4572864321608034], [1.6965963E12, 2.8633093525179865], [1.69659648E12, 2.5428194993412414], [1.69659618E12, 3.3232963549920806], [1.69659666E12, 2.3522727272727275], [1.69659636E12, 2.507812500000001], [1.69659654E12, 2.499445061043285]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69659666E12, "title": "Connect Time Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getConnectTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average Connect Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendConnectTimeOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average connect time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesConnectTimeOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotConnectTimeOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewConnectTimeOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Connect Time Over Time
function refreshConnectTimeOverTime(fixTimestamps) {
    var infos = connectTimeOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyConnectTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotConnectTimeOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesConnectTimeOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotConnectTimeOverTime", "#overviewConnectTimeOverTime");
        $('#footerConnectTimeOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var responseTimePercentilesOverTimeInfos = {
        data: {"result": {"minY": 303.0, "minX": 1.69659612E12, "maxY": 172645.0, "series": [{"data": [[1.69659624E12, 131073.0], [1.69659642E12, 97730.0], [1.69659612E12, 18687.0], [1.6965966E12, 121179.0], [1.6965963E12, 142380.0], [1.69659648E12, 171991.0], [1.69659618E12, 74236.0], [1.69659636E12, 167323.0], [1.69659654E12, 172645.0]], "isOverall": false, "label": "Max", "isController": false}, {"data": [[1.69659624E12, 75085.0], [1.69659642E12, 81257.8], [1.69659612E12, 15631.400000000003], [1.6965966E12, 120513.6], [1.6965963E12, 138397.1], [1.69659648E12, 157702.5], [1.69659618E12, 55615.0], [1.69659636E12, 120613.6], [1.69659654E12, 160494.6]], "isOverall": false, "label": "90th percentile", "isController": false}, {"data": [[1.69659624E12, 87253.65], [1.69659642E12, 88255.24], [1.69659612E12, 17928.919999999987], [1.6965966E12, 121179.0], [1.6965963E12, 142380.0], [1.69659648E12, 169194.4], [1.69659618E12, 59641.1], [1.69659636E12, 167231.02], [1.69659654E12, 171171.76]], "isOverall": false, "label": "99th percentile", "isController": false}, {"data": [[1.69659624E12, 81943.75], [1.69659642E12, 83266.2], [1.69659612E12, 16791.2], [1.6965966E12, 121135.55], [1.6965963E12, 140952.59999999998], [1.69659648E12, 162880.5], [1.69659618E12, 57611.5], [1.69659636E12, 152626.3], [1.69659654E12, 168309.6]], "isOverall": false, "label": "95th percentile", "isController": false}, {"data": [[1.69659624E12, 303.0], [1.69659642E12, 9695.0], [1.69659612E12, 1005.0], [1.6965966E12, 120077.0], [1.6965963E12, 67234.0], [1.69659648E12, 3610.0], [1.69659618E12, 9931.0], [1.69659636E12, 60076.0], [1.69659654E12, 23689.0]], "isOverall": false, "label": "Min", "isController": false}, {"data": [[1.69659624E12, 25548.0], [1.69659642E12, 70623.0], [1.69659612E12, 9920.0], [1.6965966E12, 120118.0], [1.6965963E12, 78830.0], [1.69659648E12, 29978.5], [1.69659618E12, 34139.0], [1.69659636E12, 105380.0], [1.69659654E12, 92694.0]], "isOverall": false, "label": "Median", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.6965966E12, "title": "Response Time Percentiles Over Time (successful requests only)"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Response Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentilesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Response time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentilesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimePercentilesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimePercentilesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Time Percentiles Over Time
function refreshResponseTimePercentilesOverTime(fixTimestamps) {
    var infos = responseTimePercentilesOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimePercentilesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimePercentilesOverTime", "#overviewResponseTimePercentilesOverTime");
        $('#footerResponseTimePercentilesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var responseTimeVsRequestInfos = {
    data: {"result": {"minY": 19847.0, "minX": 1.0, "maxY": 180017.0, "series": [{"data": [[2.0, 120114.5], [33.0, 26593.0], [34.0, 72439.0], [42.0, 65430.0], [43.0, 76067.0], [47.0, 66379.5], [3.0, 59809.5], [54.0, 112980.0], [57.0, 26194.0], [61.0, 120740.5], [4.0, 80669.5], [70.0, 95454.0], [5.0, 77539.0], [6.0, 120078.5], [7.0, 32828.5], [113.0, 74200.0], [8.0, 53916.0], [9.0, 30803.0], [10.0, 40863.5], [11.0, 27304.0], [12.0, 33014.0], [13.0, 42118.0], [14.0, 26858.0], [15.0, 28274.0], [1.0, 85924.0], [16.0, 52468.5], [17.0, 25803.0], [18.0, 59336.0], [19.0, 49122.5], [20.0, 68860.5], [21.0, 76394.5], [22.0, 85518.0], [23.0, 97054.0], [24.0, 80757.5], [25.0, 80290.5], [26.0, 92396.0], [27.0, 79308.5], [28.0, 19847.0], [29.0, 75605.0], [30.0, 75806.0], [31.0, 152710.0]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[2.0, 180015.5], [33.0, 120005.0], [34.0, 180017.0], [37.0, 120005.0], [36.0, 120005.5], [39.0, 120006.0], [40.0, 122010.5], [47.0, 137061.0], [3.0, 180009.0], [54.0, 116900.0], [57.0, 120009.0], [61.0, 130462.0], [4.0, 180008.0], [70.0, 92591.0], [5.0, 180007.0], [6.0, 180009.5], [7.0, 120023.0], [113.0, 165694.0], [8.0, 120019.0], [9.0, 180011.0], [10.0, 134627.0], [11.0, 180007.0], [12.0, 120011.0], [13.0, 180004.0], [14.0, 180011.0], [15.0, 120017.0], [1.0, 180010.0], [16.0, 180008.5], [17.0, 180003.5], [18.0, 180004.0], [19.0, 180008.0], [20.0, 180009.0], [21.0, 180006.0], [22.0, 150019.0], [23.0, 134446.0], [24.0, 180013.0], [25.0, 180009.0], [26.0, 180002.0], [27.0, 180010.0], [28.0, 132324.0], [29.0, 180002.5], [30.0, 173737.0], [31.0, 93527.0]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 113.0, "title": "Response Time Vs Request"}},
    getOptions: function() {
        return {
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Response Time in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: {
                noColumns: 2,
                show: true,
                container: '#legendResponseTimeVsRequest'
            },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median response time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesResponseTimeVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotResponseTimeVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewResponseTimeVsRequest"), dataset, prepareOverviewOptions(options));

    }
};

// Response Time vs Request
function refreshResponseTimeVsRequest() {
    var infos = responseTimeVsRequestInfos;
    prepareSeries(infos.data);
    if (isGraph($("#flotResponseTimeVsRequest"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeVsRequest");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimeVsRequest", "#overviewResponseTimeVsRequest");
        $('#footerResponseRimeVsRequest .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var latenciesVsRequestInfos = {
    data: {"result": {"minY": 19847.0, "minX": 1.0, "maxY": 180016.0, "series": [{"data": [[2.0, 120114.5], [33.0, 26593.0], [34.0, 72439.0], [42.0, 65430.0], [43.0, 76067.0], [47.0, 66379.0], [3.0, 59809.5], [54.0, 112980.0], [57.0, 26194.0], [61.0, 120740.0], [4.0, 80669.5], [70.0, 95454.0], [5.0, 77539.0], [6.0, 120078.5], [7.0, 32827.5], [113.0, 74200.0], [8.0, 53916.0], [9.0, 30803.0], [10.0, 40863.5], [11.0, 27303.0], [12.0, 33014.0], [13.0, 42118.0], [14.0, 26858.0], [15.0, 28274.0], [1.0, 85924.0], [16.0, 52468.5], [17.0, 25803.0], [18.0, 59336.0], [19.0, 49122.5], [20.0, 68860.0], [21.0, 76394.0], [22.0, 85518.0], [23.0, 97054.0], [24.0, 80757.5], [25.0, 80290.5], [26.0, 92396.0], [27.0, 79308.5], [28.0, 19847.0], [29.0, 75605.0], [30.0, 75806.0], [31.0, 152710.0]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[2.0, 180015.5], [33.0, 120005.0], [34.0, 180016.0], [37.0, 120005.0], [36.0, 120005.5], [39.0, 120006.0], [40.0, 122010.5], [47.0, 137061.0], [3.0, 180009.0], [54.0, 116900.0], [57.0, 120009.0], [61.0, 130462.0], [4.0, 180008.0], [70.0, 92590.0], [5.0, 180007.0], [6.0, 180009.5], [7.0, 120023.0], [113.0, 165694.0], [8.0, 120019.0], [9.0, 180011.0], [10.0, 134627.0], [11.0, 180007.0], [12.0, 120011.0], [13.0, 180004.0], [14.0, 180011.0], [15.0, 120017.0], [1.0, 180010.0], [16.0, 180008.5], [17.0, 180003.0], [18.0, 180004.0], [19.0, 180007.0], [20.0, 180008.5], [21.0, 180006.0], [22.0, 150019.0], [23.0, 134445.0], [24.0, 180013.0], [25.0, 180009.0], [26.0, 180002.0], [27.0, 180010.0], [28.0, 132324.0], [29.0, 180002.0], [30.0, 173737.0], [31.0, 93526.5]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 113.0, "title": "Latencies Vs Request"}},
    getOptions: function() {
        return{
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Latency in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: { noColumns: 2,show: true, container: '#legendLatencyVsRequest' },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median Latency time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesLatencyVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotLatenciesVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewLatenciesVsRequest"), dataset, prepareOverviewOptions(options));
    }
};

// Latencies vs Request
function refreshLatenciesVsRequest() {
        var infos = latenciesVsRequestInfos;
        prepareSeries(infos.data);
        if(isGraph($("#flotLatenciesVsRequest"))){
            infos.createGraph();
        }else{
            var choiceContainer = $("#choicesLatencyVsRequest");
            createLegend(choiceContainer, infos);
            infos.createGraph();
            setGraphZoomable("#flotLatenciesVsRequest", "#overviewLatenciesVsRequest");
            $('#footerLatenciesVsRequest .legendColorBox > div').each(function(i){
                $(this).clone().prependTo(choiceContainer.find("li").eq(i));
            });
        }
};

var hitsPerSecondInfos = {
        data: {"result": {"minY": 1.8166666666666667, "minX": 1.69659612E12, "maxY": 22.466666666666665, "series": [{"data": [[1.69659624E12, 22.466666666666665], [1.69659642E12, 15.083333333333334], [1.69659612E12, 16.116666666666667], [1.6965963E12, 1.8166666666666667], [1.69659648E12, 11.166666666666666], [1.69659618E12, 11.75], [1.69659636E12, 14.85]], "isOverall": false, "label": "hitsPerSecond", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69659648E12, "title": "Hits Per Second"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of hits / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendHitsPerSecond"
                },
                selection: {
                    mode : 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y.2 hits/sec"
                }
            };
        },
        createGraph: function createGraph() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesHitsPerSecond"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotHitsPerSecond"), dataset, options);
            // setup overview
            $.plot($("#overviewHitsPerSecond"), dataset, prepareOverviewOptions(options));
        }
};

// Hits per second
function refreshHitsPerSecond(fixTimestamps) {
    var infos = hitsPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if (isGraph($("#flotHitsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesHitsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotHitsPerSecond", "#overviewHitsPerSecond");
        $('#footerHitsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var codesPerSecondInfos = {
        data: {"result": {"minY": 0.03333333333333333, "minX": 1.69659612E12, "maxY": 11.9, "series": [{"data": [[1.69659624E12, 10.566666666666666], [1.69659642E12, 10.05], [1.69659612E12, 3.183333333333333], [1.6965966E12, 1.4666666666666666], [1.6965963E12, 0.4666666666666667], [1.69659648E12, 11.9], [1.69659618E12, 10.483333333333333], [1.69659636E12, 1.95], [1.69659654E12, 11.516666666666667]], "isOverall": false, "label": "200", "isController": false}, {"data": [[1.69659624E12, 0.06666666666666667], [1.6965963E12, 1.0833333333333333], [1.69659618E12, 0.03333333333333333], [1.69659636E12, 2.85]], "isOverall": false, "label": "502", "isController": false}, {"data": [[1.69659624E12, 1.85], [1.69659642E12, 7.133333333333334], [1.6965966E12, 1.85], [1.6965963E12, 3.0833333333333335], [1.69659648E12, 0.75], [1.69659666E12, 1.4666666666666666], [1.69659636E12, 8.0], [1.69659654E12, 3.5]], "isOverall": false, "label": "504", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69659666E12, "title": "Codes Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendCodesPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "Number of Response Codes %s at %x was %y.2 responses / sec"
                }
            };
        },
    createGraph: function() {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesCodesPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotCodesPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewCodesPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Codes per second
function refreshCodesPerSecond(fixTimestamps) {
    var infos = codesPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotCodesPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesCodesPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotCodesPerSecond", "#overviewCodesPerSecond");
        $('#footerCodesPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var transactionsPerSecondInfos = {
        data: {"result": {"minY": 0.03333333333333333, "minX": 1.69659612E12, "maxY": 11.9, "series": [{"data": [[1.69659624E12, 10.566666666666666], [1.69659642E12, 10.05], [1.69659612E12, 3.183333333333333], [1.6965966E12, 1.4666666666666666], [1.6965963E12, 0.4666666666666667], [1.69659648E12, 11.9], [1.69659618E12, 10.483333333333333], [1.69659636E12, 1.95], [1.69659654E12, 11.516666666666667]], "isOverall": false, "label": "HTTP Request-success", "isController": false}, {"data": [[1.69659624E12, 1.9166666666666667], [1.69659642E12, 7.133333333333334], [1.6965966E12, 1.85], [1.6965963E12, 4.166666666666667], [1.69659648E12, 0.75], [1.69659618E12, 0.03333333333333333], [1.69659666E12, 1.4666666666666666], [1.69659636E12, 10.85], [1.69659654E12, 3.5]], "isOverall": false, "label": "HTTP Request-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69659666E12, "title": "Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTransactionsPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                }
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTransactionsPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTransactionsPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewTransactionsPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Transactions per second
function refreshTransactionsPerSecond(fixTimestamps) {
    var infos = transactionsPerSecondInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTransactionsPerSecond");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTransactionsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTransactionsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTransactionsPerSecond", "#overviewTransactionsPerSecond");
        $('#footerTransactionsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var totalTPSInfos = {
        data: {"result": {"minY": 0.03333333333333333, "minX": 1.69659612E12, "maxY": 11.9, "series": [{"data": [[1.69659624E12, 10.566666666666666], [1.69659642E12, 10.05], [1.69659612E12, 3.183333333333333], [1.6965966E12, 1.4666666666666666], [1.6965963E12, 0.4666666666666667], [1.69659648E12, 11.9], [1.69659618E12, 10.483333333333333], [1.69659636E12, 1.95], [1.69659654E12, 11.516666666666667]], "isOverall": false, "label": "Transaction-success", "isController": false}, {"data": [[1.69659624E12, 1.9166666666666667], [1.69659642E12, 7.133333333333334], [1.6965966E12, 1.85], [1.6965963E12, 4.166666666666667], [1.69659648E12, 0.75], [1.69659618E12, 0.03333333333333333], [1.69659666E12, 1.4666666666666666], [1.69659636E12, 10.85], [1.69659654E12, 3.5]], "isOverall": false, "label": "Transaction-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69659666E12, "title": "Total Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTotalTPS"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                },
                colors: ["#9ACD32", "#FF6347"]
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTotalTPS"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTotalTPS"), dataset, options);
        // setup overview
        $.plot($("#overviewTotalTPS"), dataset, prepareOverviewOptions(options));
    }
};

// Total Transactions per second
function refreshTotalTPS(fixTimestamps) {
    var infos = totalTPSInfos;
    // We want to ignore seriesFilter
    prepareSeries(infos.data, false, true);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTotalTPS"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTotalTPS");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTotalTPS", "#overviewTotalTPS");
        $('#footerTotalTPS .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

// Collapse the graph matching the specified DOM element depending the collapsed
// status
function collapse(elem, collapsed){
    if(collapsed){
        $(elem).parent().find(".fa-chevron-up").removeClass("fa-chevron-up").addClass("fa-chevron-down");
    } else {
        $(elem).parent().find(".fa-chevron-down").removeClass("fa-chevron-down").addClass("fa-chevron-up");
        if (elem.id == "bodyBytesThroughputOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshBytesThroughputOverTime(true);
            }
            document.location.href="#bytesThroughputOverTime";
        } else if (elem.id == "bodyLatenciesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesOverTime(true);
            }
            document.location.href="#latenciesOverTime";
        } else if (elem.id == "bodyCustomGraph") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCustomGraph(true);
            }
            document.location.href="#responseCustomGraph";
        } else if (elem.id == "bodyConnectTimeOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshConnectTimeOverTime(true);
            }
            document.location.href="#connectTimeOverTime";
        } else if (elem.id == "bodyResponseTimePercentilesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimePercentilesOverTime(true);
            }
            document.location.href="#responseTimePercentilesOverTime";
        } else if (elem.id == "bodyResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeDistribution();
            }
            document.location.href="#responseTimeDistribution" ;
        } else if (elem.id == "bodySyntheticResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshSyntheticResponseTimeDistribution();
            }
            document.location.href="#syntheticResponseTimeDistribution" ;
        } else if (elem.id == "bodyActiveThreadsOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshActiveThreadsOverTime(true);
            }
            document.location.href="#activeThreadsOverTime";
        } else if (elem.id == "bodyTimeVsThreads") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTimeVsThreads();
            }
            document.location.href="#timeVsThreads" ;
        } else if (elem.id == "bodyCodesPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCodesPerSecond(true);
            }
            document.location.href="#codesPerSecond";
        } else if (elem.id == "bodyTransactionsPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTransactionsPerSecond(true);
            }
            document.location.href="#transactionsPerSecond";
        } else if (elem.id == "bodyTotalTPS") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTotalTPS(true);
            }
            document.location.href="#totalTPS";
        } else if (elem.id == "bodyResponseTimeVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeVsRequest();
            }
            document.location.href="#responseTimeVsRequest";
        } else if (elem.id == "bodyLatenciesVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesVsRequest();
            }
            document.location.href="#latencyVsRequest";
        }
    }
}

/*
 * Activates or deactivates all series of the specified graph (represented by id parameter)
 * depending on checked argument.
 */
function toggleAll(id, checked){
    var placeholder = document.getElementById(id);

    var cases = $(placeholder).find(':checkbox');
    cases.prop('checked', checked);
    $(cases).parent().children().children().toggleClass("legend-disabled", !checked);

    var choiceContainer;
    if ( id == "choicesBytesThroughputOverTime"){
        choiceContainer = $("#choicesBytesThroughputOverTime");
        refreshBytesThroughputOverTime(false);
    } else if(id == "choicesResponseTimesOverTime"){
        choiceContainer = $("#choicesResponseTimesOverTime");
        refreshResponseTimeOverTime(false);
    }else if(id == "choicesResponseCustomGraph"){
        choiceContainer = $("#choicesResponseCustomGraph");
        refreshCustomGraph(false);
    } else if ( id == "choicesLatenciesOverTime"){
        choiceContainer = $("#choicesLatenciesOverTime");
        refreshLatenciesOverTime(false);
    } else if ( id == "choicesConnectTimeOverTime"){
        choiceContainer = $("#choicesConnectTimeOverTime");
        refreshConnectTimeOverTime(false);
    } else if ( id == "choicesResponseTimePercentilesOverTime"){
        choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        refreshResponseTimePercentilesOverTime(false);
    } else if ( id == "choicesResponseTimePercentiles"){
        choiceContainer = $("#choicesResponseTimePercentiles");
        refreshResponseTimePercentiles();
    } else if(id == "choicesActiveThreadsOverTime"){
        choiceContainer = $("#choicesActiveThreadsOverTime");
        refreshActiveThreadsOverTime(false);
    } else if ( id == "choicesTimeVsThreads"){
        choiceContainer = $("#choicesTimeVsThreads");
        refreshTimeVsThreads();
    } else if ( id == "choicesSyntheticResponseTimeDistribution"){
        choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        refreshSyntheticResponseTimeDistribution();
    } else if ( id == "choicesResponseTimeDistribution"){
        choiceContainer = $("#choicesResponseTimeDistribution");
        refreshResponseTimeDistribution();
    } else if ( id == "choicesHitsPerSecond"){
        choiceContainer = $("#choicesHitsPerSecond");
        refreshHitsPerSecond(false);
    } else if(id == "choicesCodesPerSecond"){
        choiceContainer = $("#choicesCodesPerSecond");
        refreshCodesPerSecond(false);
    } else if ( id == "choicesTransactionsPerSecond"){
        choiceContainer = $("#choicesTransactionsPerSecond");
        refreshTransactionsPerSecond(false);
    } else if ( id == "choicesTotalTPS"){
        choiceContainer = $("#choicesTotalTPS");
        refreshTotalTPS(false);
    } else if ( id == "choicesResponseTimeVsRequest"){
        choiceContainer = $("#choicesResponseTimeVsRequest");
        refreshResponseTimeVsRequest();
    } else if ( id == "choicesLatencyVsRequest"){
        choiceContainer = $("#choicesLatencyVsRequest");
        refreshLatenciesVsRequest();
    }
    var color = checked ? "black" : "#818181";
    if(choiceContainer != null) {
        choiceContainer.find("label").each(function(){
            this.style.color = color;
        });
    }
}

